% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateTableOneJS.R
\name{CreateTableOneJS}
\alias{CreateTableOneJS}
\title{CreateTableOneJS: Modified CreateTableOne function in tableone package}
\usage{
CreateTableOneJS(vars, strata = NULL, strata2 = NULL, data,
  factorVars = NULL, includeNA = F, test = T,
  testApprox = chisq.test, argsApprox = list(correct = TRUE),
  testExact = fisher.test, argsExact = list(workspace = 2 * 10^5),
  testNormal = oneway.test, argsNormal = list(var.equal = F),
  testNonNormal = kruskal.test, argsNonNormal = list(NULL),
  showAllLevels = T, printToggle = F, quote = F, smd = F,
  Labels = F, exact = NULL, nonnormal = NULL, catDigits = 1,
  contDigits = 2, pDigits = 3, labeldata = NULL, psub = T)
}
\arguments{
\item{vars}{Variables to be summarized given as a character vector. Factors are handled as categorical variables, whereas numeric variables are handled as continuous variables. If empty, all variables in the data frame specified in the data argument are used.}

\item{strata}{Stratifying grouping variable name(s) given as a character vector. If omitted, the overall results are returned.}

\item{strata2}{Stratifying 2nd grouping variable name(s) given as a character vector. If omitted, the 1 group results are returned.}

\item{data}{A data frame in which these variables exist. All variables (both vars and strata) must be in this data frame.}

\item{factorVars}{Numerically coded variables that should be handled as categorical variables given as a character vector. Do not include factors, unless you need to relevel them by removing empty levels. If omitted, only factors are considered categorical variables. The variables specified here must also be specified in the vars argument.}

\item{includeNA}{If TRUE, NA is handled as a regular factor level rather than missing. NA is shown as the last factor level in the table. Only effective for categorical variables., Default: F}

\item{test}{If TRUE, as in the default and there are more than two groups, groupwise comparisons are performed, Default: T}

\item{testApprox}{A function used to perform the large sample approximation based tests. The default is chisq.test. This is not recommended when some of the cell have small counts like fewer than 5, Default: chisq.test}

\item{argsApprox}{A named list of arguments passed to the function specified in testApprox. The default is list(correct = TRUE), which turns on the continuity correction for chisq.test, Default: list(correct = TRUE)}

\item{testExact}{A function used to perform the exact tests. The default is fisher.test. If the cells have large numbers, it will fail because of memory limitation. In this situation, the large sample approximation based should suffice., Default: fisher.test}

\item{argsExact}{A named list of arguments passed to the function specified in testExact. The default is list(workspace = 2 * 10^5), which specifies the memory space allocated for fisher.test, Default: list(workspace = 2 * 10^5)}

\item{testNormal}{A function used to perform the normal assumption based tests. The default is oneway.test. This is equivalent of the t-test when there are only two groups, Default: oneway.test}

\item{argsNormal}{A named list of arguments passed to the function specified in testNormal. The default is list(var.equal = TRUE), which makes it the ordinary ANOVA that assumes equal variance across groups., Default: list(var.equal = F)}

\item{testNonNormal}{A function used to perform the nonparametric tests. The default is kruskal.test (Kruskal-Wallis Rank Sum Test). This is equivalent of the wilcox.test (Man-Whitney U test) when there are only two groups, Default: kruskal.test}

\item{argsNonNormal}{A named list of arguments passed to the function specified in testNonNormal. The default is list(NULL), which is just a placeholder., Default: list(NULL)}

\item{showAllLevels}{Whether to show all levels. FALSE by default, i.e., for 2-level categorical variables, only the higher level is shown to avoid redundant information., Default: T}

\item{printToggle}{Whether to print the output. If FALSE, no output is created, and a matrix is invisibly returned., Default: F}

\item{quote}{Whether to show everything in quotes. The default is FALSE. If TRUE, everything including the row and column names are quoted so that you can copy it to Excel easily, Default: F}

\item{smd}{If TRUE, as in the default and there are more than two groups, standardized mean differences for all pairwise comparisons are calculated, Default: F}

\item{Labels}{Use Label, Default: F}

\item{exact}{A character vector to specify the variables for which the p-values should be those of exact tests. By default all p-values are from large sample approximation tests (chisq.test)., Default: NULL}

\item{nonnormal}{A character vector to specify the variables for which the p-values should be those of nonparametric tests. By default all p-values are from normal assumption-based tests (oneway.test)., Default: NULL}

\item{catDigits}{Number of digits to print for proportions., Default: 1}

\item{contDigits}{Number of digits to print for continuous variables. Default 2.}

\item{pDigits}{Number of digits to print for p-values (also used for standardized mean differences), Default: 3}

\item{labeldata}{labeldata to use, Default: NULL}

\item{psub}{show sub-group p-values, Default: F}
}
\value{
A matrix object containing what you see is also invisibly returned. This can be assinged a name and exported via write.csv.
}
\description{
Combine CreateTableOne & print function in tableone package
}
\details{
DETAILS
}
\examples{
 library(survival)
 CreateTableOneJS(vars = names(lung), strata = "sex", data = lung)
}
