% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmrm.R
\name{get_mmrm_lsmeans}
\alias{get_mmrm_lsmeans}
\title{Extract Least Square Means from \code{MMRM}}
\usage{
get_mmrm_lsmeans(fit, vars, conf_level, weights, averages = list())
}
\arguments{
\item{fit}{(\code{mmrm})\cr result of \code{\link[mmrm:mmrm]{mmrm::mmrm()}}.}

\item{vars}{(named \code{list} of \code{string} or \code{character})\cr specifying the variables in the \code{MMRM}.
The following elements need to be included as character vectors and match corresponding columns
in \code{data}:
\itemize{
\item \code{response}: the response variable.
\item \code{covariates}: the additional covariate terms (might also include interactions).
\item \code{id}: the subject ID variable.
\item \code{arm}: the treatment group variable (factor).
\item \code{visit}: the visit variable (factor).
\item \code{weights}: optional weights variable (if \code{NULL} or omitted then no weights will be used).
}

Note that the main effects and interaction of \code{arm} and \code{visit} are by default
included in the model.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{weights}{(\code{string})\cr type of weights to be used for the least square means,
see \code{\link[emmeans:emmeans]{emmeans::emmeans()}} for details.}

\item{averages}{(\code{list})\cr named list of visit levels which should be averaged
and reported along side the single visits.}
}
\value{
A list with data frames \code{estimates} and \code{contrasts}.
The attributes \code{averages} and \code{weights} save the settings used.
}
\description{
Extracts the least square means from an \code{MMRM} fit.
}
