% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbmi.R
\name{find_missing_chg_after_avisit}
\alias{find_missing_chg_after_avisit}
\title{Helper for Finding AVISIT after which CHG are all Missing}
\usage{
find_missing_chg_after_avisit(df)
}
\arguments{
\item{df}{(\code{data.frame})\cr with \code{CHG} and \code{AVISIT} variables.}
}
\value{
A string with either the factor level after which \code{AVISIT} is all missing,
or \code{NA}.
}
\description{
Helper for Finding AVISIT after which CHG are all Missing.
}
\examples{
df <- data.frame(
  AVISIT = factor(c(1, 2, 3, 4, 5)),
  CHG = c(5, NA, NA, NA, 3)
)
find_missing_chg_after_avisit(df)

df2 <- data.frame(
  AVISIT = factor(c(1, 2, 3, 4, 5)),
  CHG = c(5, NA, 3, NA, NA)
)
find_missing_chg_after_avisit(df2)

df3 <- data.frame(
  AVISIT = factor(c(1, 2, 3, 4, 5)),
  CHG = c(NA, NA, NA, NA, NA)
)
find_missing_chg_after_avisit(df3)
}
