% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruning_functions.R
\name{remove_rows}
\alias{remove_rows}
\title{Pruning function to remove specific rows of a table regardless of counts}
\usage{
remove_rows(removerowtext = NULL, reg_expr = FALSE)
}
\arguments{
\item{removerowtext}{(\code{character})\cr Define a text string for which any row with row text will be removed.}

\item{reg_expr}{(\code{logical})\cr Apply removerowtext as a regular expression
(grepl with fixed = TRUE)}
}
\value{
Function that can be utilized as pruning function in prune_table.
}
\description{
This function will remove all rows of a table based on the row text
provided by the user.
}
\examples{
ADSL <- data.frame(
  USUBJID = c(
    "XXXXX01", "XXXXX02", "XXXXX03", "XXXXX04", "XXXXX05",
    "XXXXX06", "XXXXX07", "XXXXX08", "XXXXX09", "XXXXX10"
  ),
  TRT01P = c(
    "ARMA", "ARMB", "ARMA", "ARMB", "ARMB", "Placebo",
    "Placebo", "Placebo", "ARMA", "ARMB"
  ),
  Category = c(
    "Cat 1", "Cat 2", "Cat 1", "Unknown", "Cat 2",
    "Cat 1", "Unknown", "Cat 1", "Cat 2", "Cat 1"
  ),
  SAFFL = c("N", "N", "N", "N", "N", "N", "N", "N", "N", "N"),
  PKFL = c("N", "N", "N", "N", "N", "N", "N", "N", "N", "N")
)

ADSL <- ADSL |>
  dplyr::mutate(TRT01P = as.factor(TRT01P))

lyt <- basic_table() |>
  split_cols_by("TRT01P") |>
  analyze(
    "Category",
    afun = a_freq_j,
    extra_args = list(.stats = "count_unique_fraction")
  )

result <- build_table(lyt, ADSL)

result

result <- prune_table(result, prune_func = remove_rows(removerowtext = "Unknown"))

result
}
