% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_K.R
\name{calc_k}
\alias{calc_k}
\title{Calculate the limit of the number of junctions}
\usage{
calc_k(N = Inf, R = Inf, H_0 = 0.5, C = 1)
}
\arguments{
\item{N}{population size}

\item{R}{number of markers}

\item{H_0}{initial heterozygosity (at the time of admixture)}

\item{C}{Mean number of crossovers per meiosis (e.g. size in Morgan of
the chromosome)}
}
\value{
The number of junctions for at time = infinity
}
\description{
Calculate the average number of junctions after an infinite
number of generations, provided information on the initial heterozygosity,
population size and the number of generations.
}
\examples{
k <-  calc_k(N = 100, R = 1000, H_0 = 0.5, C = 1)
}
\keyword{junctions}
