% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_from_json.R
\name{import_from_json}
\alias{import_from_json}
\title{Import a structured justifier object from JSON}
\usage{
import_from_json(x)
}
\arguments{
\item{x}{Either a path to an existing file, or a character vector with the
JSON to import.}
}
\value{
The justifier object.
}
\description{
Import a structured justifier object from JSON
}
\examples{
### Programmatically create a justification with two assertions
### but without sources; flatten it; and show the json
justifier::justify(
  "Icecream will make me feel less fit",
  assertion = c(
    justifier::assert('Icecream is rich in energy'),
    justifier::assert('Consuming high-energy foods makes me feel less fit')
  ),
  weight = -.5
) |>
  justifier::flatten() -> originalObject;

originalObject |>
  justifier::export_to_json() ->
  exportedJSON;

### And import it again
importedFromJSON <-
  justifier::import_from_json(
    exportedJSON
  );
}
