% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.r
\name{expect_that_combine_all_args}
\alias{expect_that_combine_all_args}
\alias{expect_that_combine_first_arg}
\title{alternative \code{expect_that} from \code{testthat} which permutes all
  the inputs to a function which should give the same result where n args >=2
  and the function is commutative.}
\usage{
expect_that_combine_all_args(object, condition, info = NULL, label = NULL)

expect_that_combine_first_arg(object, condition, info = NULL, label = NULL)
}
\arguments{
\item{object}{object to test}

\item{condition}{a function that returns whether or not the condition
is met, and if not, an error message to display.}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}
}
\value{
testthat result
}
\description{
This makes a lot of assumptions, needs more testing. It can't
  handle mixed error/no error outcomes after permutation, which is an
  important feature to consider. The command following this function attaches
  this function to the testthat namespace. This means that it can call
  internal testthat functions, but does not mean it appears as
  testthat::expect_that_combine
}
\examples{
 expect_that_combine_all_args(sum(1, 2, 3),
  testthat::equals(6))
}

