% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_spec.R
\name{row_spec}
\alias{row_spec}
\title{Specify the look of the selected row}
\usage{
row_spec(
  kable_input,
  row,
  bold = FALSE,
  italic = FALSE,
  monospace = FALSE,
  underline = FALSE,
  strikeout = FALSE,
  color = NULL,
  background = NULL,
  align = NULL,
  font_size = NULL,
  angle = NULL,
  extra_css = NULL,
  hline_after = FALSE,
  extra_latex_after = NULL
)
}
\arguments{
\item{kable_input}{Output of \code{knitr::kable()} with \code{format} specified}

\item{row}{A numeric value or vector indicating which row(s) to be selected. You don't
need to count in header rows or group labeling rows.}

\item{bold}{A T/F value to control whether the text of the selected row
need to be bolded.}

\item{italic}{A T/F value to control whether the text of the selected row
need to be emphasized.}

\item{monospace}{A T/F value to control whether the text of the selected row
need to be monospaced (verbatim)}

\item{underline}{A T/F value to control whether the text of the selected row
need to be underlined}

\item{strikeout}{A T/F value to control whether the text of the selected row
need to be stricked out.}

\item{color}{A character string for row text color. For example, "red" or
"#BBBBBB".}

\item{background}{A character string for row background color. Here please
pay attention to the differences in color codes between HTML and LaTeX.}

\item{align}{A character string for cell alignment. For HTML, possible values could
be \code{l}, \code{c}, \code{r} plus \code{left}, \code{center}, \code{right}, \code{justify}, \code{initial} and \code{inherit}
while for LaTeX, you can only choose from \code{l}, \code{c} & \code{r}.}

\item{font_size}{A numeric input for font size. For HTML, you can also use
options including \code{xx-small}, \code{x-small}, \code{small}, \code{medium}, \code{large},
\code{x-large}, \code{xx-large}, \code{smaller}, \code{larger}, \code{initial} and \code{inherit}.}

\item{angle}{0-360, degree that the text will rotate.}

\item{extra_css}{Extra css text to be passed into the cells of the row. Note
that it's not for the whole row.}

\item{hline_after}{T/F. A replicate of \code{hline.after} in xtable. It
addes a hline after ther row}

\item{extra_latex_after}{Extra LaTeX text to be added after the row. Similar
with \code{add.to.row} in xtable}
}
\description{
This function allows users to select a row and then specify
its look. It can also specify the format of the header row when \code{row} = 0.
}
\examples{
\dontrun{
x <- knitr::kable(head(mtcars), "html")
row_spec(x, 1:2, bold = TRUE, italic = TRUE)
}

}
