% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.r
\name{calc_kernel}
\alias{calc_kernel}
\alias{calc_kernel,GWASdata-method}
\alias{lin_kernel,GWASdata-method}
\alias{lin_kernel}
\alias{sia_kernel,GWASdata-method}
\alias{sia_kernel}
\alias{net_kernel,GWASdata-method}
\alias{net_kernel}
\title{Calculate the kernel-matrix for a pathway}
\usage{
\S4method{calc_kernel}{GWASdata}(
  object,
  pathway,
  knots = NULL,
  type = c("lin", "sia", "net"),
  calculation = c("cpu", "gpu"),
  ...
)

\S4method{lin_kernel}{GWASdata}(object, pathway, knots = NULL, calculation = c("cpu", "gpu"), ...)

\S4method{sia_kernel}{GWASdata}(object, pathway, knots = NULL, calculation = c("cpu", "gpu"), ...)

\S4method{net_kernel}{GWASdata}(object, pathway, knots = NULL, calculation = c("cpu", "gpu"), ...)
}
\arguments{
\item{object}{\code{GWASdata} object containing the genotypes of the 
individuals for which a \code{\link{kernel}} will be calculated.}

\item{pathway}{object of the class \code{\link{pathway}} specifying the SNP set 
for which a \code{\link{kernel}} will be calculated.}

\item{knots}{\code{GWASdata} object, if specified a \code{\link{kernel}}
will be computed.}

\item{type}{\code{character} indicating the \code{\link{kernel}} type: 
Use \code{'lin'} to specify the linear kernel, \code{'sia'} for the 
size-adjusted or \code{'net'} for the network-based kernel.}

\item{calculation}{\code{character} specifying if the kernel \code{matrix} 
is computed on CPU or GPU.}

\item{...}{further arguments to be passed to \code{\link{kernel}} computations.}
}
\value{
Returns an object of class \code{\link{kernel}}, including the similarity 
\code{matrix} of the \code{\link{pathway}} for the considered individuals. \cr
If \code{knots} are specified low-rank kernel of class a \code{lowrank_kernel} 
will be returned, which is not necessarily quadratic and symmetric.
}
\description{
Uses individuals' genotypes to create a \code{\link{kernel}} object including 
the calculated kernel \code{matrix} for a specific \code{\link{pathway}}.
Each numeric value within this \code{matrix} is calculated
from two individuals' genotypevectors of the SNPs within 
the \code{\link{pathway}} by a kernel function. It can be interpreted as the genetic 
similiarity of the individuals. Association between the \code{\link{pathway}} and a 
binary phenotype (case-control status) can be evaluated
in the logistic kernel machine test, based on the \code{\link{kernel}} object. 
Three kernel functions are available.
}
\details{
Different types of kernels can be constructed:
\itemize{
  \item \code{type='lin'} creates the linear kernel assuming additive SNP 
effects to be evaluated in the logistic kernel machine test.
  \item \code{type='sia'} calculates the size-adjusted kernel which takes 
into consideration the numbers of SNPs and genes in a \code{\link{pathway}} 
to correct for size bias.
  \item \code{type='net'} calculates the network-based kernel. Here not only information on gene membership and gene/pathway size in number of SNPs is incorporated, but also the interaction structure of genes in the \code{\link{pathway}}.
}
For more details, check the references.
}
\section{Methods (by class)}{
\itemize{
\item \code{lin_kernel(GWASdata)}: 

\item \code{sia_kernel(GWASdata)}: 

\item \code{net_kernel(GWASdata)}: 

}}
\examples{
data(gwas)
data(hsa04020)
lin_kernel <- calc_kernel(gwas, hsa04020, knots=NULL, type='lin', calculation='cpu')
summary(lin_kernel)
net_kernel <- calc_kernel(gwas, hsa04020, knots=NULL, type='net', calculation='cpu')
summary(net_kernel)

}
\references{
\itemize{
 \item Wu MC, Kraft P, Epstein MP, Taylor DM, Chanock SJ, Hunter DJ, Lin X Powerful SNP-Set Analysis for Case-Control Genome-Wide Association Studies. Am J Hum Genet 2010, 86:929-42
 \item Freytag S, Bickeboeller H, Amos CI, Kneib T, Schlather M: A Novel Kernel for Correcting Size Bias in the Logistic Kernel Machine Test with an Application to Rheumatoid Arthritis. Hum Hered. 2012, 74(2):97-108.
 \item Freytag S, Manitz J, Schlather M, Kneib T, Amos CI, Risch A, Chang-Claude J, Heinrich J, Bickeboeller H: A network-based kernel machine test for the identification of risk pathways in genome-wide association studies. Hum Hered. 2013, 76(2):64-75.
}
}
\seealso{
\code{\link{kernel-class}},\code{\link{pathway}}
}
\author{
Stefanie Friedrichs, Juliane Manitz
}
