% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt_parallel_coordinates.R
\name{plt_parallel_coordinates}
\alias{plt_parallel_coordinates}
\title{plt_parallel_coordinates}
\usage{
plt_parallel_coordinates(
  data,
  cols = NULL,
  color_variable = NULL,
  color_args = list(alpha = 0.6, begin = 0.1, end = 0.9, option = "inferno", direction =
    1),
  line_jitter = list(w = 0.04, h = 0.04),
  text_label_size = 3.5
)
}
\arguments{
\item{data}{A data.table object with the columns containing the parameters to
be plotted with the parallel coordinates plot.}

\item{cols}{A character vector with column names to subset \code{data} (default:
\code{NULL}).}

\item{color_variable}{A character. The name of the column to be used to
colorize the lines of the plot (default: \code{NULL}).}

\item{color_args}{A list with parameters for the color gradient (see
details).}

\item{line_jitter}{A list with the elements \code{w} and \code{h} to define a line
jitter (default: \code{list(w = 0.04, h = 0.04)}), which are passed further on
to define the position of \code{ggplot2::geom_line()}.}

\item{text_label_size}{A numeric value to define the size of the text
annotations (default: \code{3.5}).}
}
\value{
Returns a parallel coordinates plot as \code{ggplot2} object.
}
\description{
Parallel coordinates plot
}
\details{
The color gradient of the plotted lines can be defined with a list
provided to the argument \code{color_args}. Its default values are
\code{alpha = 0.6}, \code{begin = .1}, \code{end = .9}, \code{option = "inferno"}, and
\code{direction = 1} and are passed furhter on to
\code{ggplot2::scale_color_viridis_c()}.
The implementation to display categorical variables is still experimental.
}
\examples{
if (require("ggplot2")) {
  data("iris")
  plt_parallel_coordinates(
    data = data.table::as.data.table(iris[, -5]),
    cols = colnames(iris)[c(-1, -5)],
    color_variable = "Sepal.Length"
  )
}
}
\seealso{
\code{\link[ggplot2:scale_viridis]{ggplot2::scale_color_viridis_c()}}
}
