% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{dataset_fashion_mnist}
\alias{dataset_fashion_mnist}
\title{Fashion-MNIST database of fashion articles}
\usage{
dataset_fashion_mnist()
}
\value{
Lists of training and test data: \code{train$x, train$y, test$x, test$y}, where
\code{x} is an array of grayscale image data with shape (num_samples, 28, 28) and \code{y}
is an array of article labels (integers in range 0-9) with shape (num_samples).
}
\description{
Dataset of 60,000 28x28 grayscale images of the 10 fashion article classes,
along with a test set of 10,000 images. This dataset can be used as a drop-in
replacement for MNIST. The class labels are encoded as integers from 0-9 which
correspond to T-shirt/top, Trouser, Pullover, Dress, Coat, Sandal, Shirt,
}
\details{
Dataset of 60,000 28x28 grayscale images of 10 fashion categories,
along with a test set of 10,000 images. This dataset can be used as a drop-in
replacement for MNIST. The class labels are:
\itemize{
\item 0 - T-shirt/top
\item 1 - Trouser
\item 2 - Pullover
\item 3 - Dress
\item 4 - Coat
\item 5 - Sandal
\item 6 - Shirt
\item 7 - Sneaker
\item 8 - Bag
\item 9 - Ankle boot
}
}
\seealso{
Other datasets: \code{\link{dataset_boston_housing}},
  \code{\link{dataset_cifar100}},
  \code{\link{dataset_cifar10}},
  \code{\link{dataset_imdb}}, \code{\link{dataset_mnist}},
  \code{\link{dataset_reuters}}
}
