% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_dropout}
\alias{k_dropout}
\title{Sets entries in \code{x} to zero at random, while scaling the entire tensor.}
\usage{
k_dropout(x, level, noise_shape = NULL, seed = NULL)
}
\arguments{
\item{x}{tensor}

\item{level}{fraction of the entries in the tensor that will be set to 0.}

\item{noise_shape}{shape for randomly generated keep/drop flags, must be
broadcastable to the shape of \code{x}}

\item{seed}{random seed to ensure determinism.}
}
\value{
A tensor.
}
\description{
Sets entries in \code{x} to zero at random, while scaling the entire tensor.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

