% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{save_model_weights_tf}
\alias{save_model_weights_tf}
\alias{load_model_weights_tf}
\title{Save model weights in the SavedModel format}
\usage{
save_model_weights_tf(object, filepath, overwrite = TRUE)

load_model_weights_tf(object, filepath, by_name = FALSE,
  skip_mismatch = FALSE, reshape = FALSE)
}
\arguments{
\item{object}{Model object to save/load}

\item{filepath}{Path to the file}

\item{overwrite}{Whether to silently overwrite any existing
file at the target location}

\item{by_name}{Whether to load weights by name or by topological order.}

\item{skip_mismatch}{Logical, whether to skip loading of layers
where there is a mismatch in the number of weights, or a mismatch in the
shape of the weight (only valid when \code{by_name = FALSE}).}

\item{reshape}{Reshape weights to fit the layer when the correct number
of values are present but the shape does not match.}
}
\description{
Save model weights in the SavedModel format
}
\details{
When saving in TensorFlow format, all objects referenced by the network
are saved in the same format as \code{tf.train.Checkpoint}, including any Layer instances
or Optimizer instances assigned to object attributes. For networks constructed from
inputs and outputs using \code{tf.keras.Model(inputs, outputs)}, Layer instances used by
the network are tracked/saved automatically. For user-defined classes which inherit
from \code{tf.keras.Model}, Layer instances must be assigned to object attributes,
typically in the constructor.

See the documentation of \code{tf.train.Checkpoint} and \code{tf.keras.Model} for details.
}
