% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-pooling.R
\name{layer_max_pooling_3d}
\alias{layer_max_pooling_3d}
\title{Max pooling operation for 3D data (spatial or spatio-temporal).}
\usage{
layer_max_pooling_3d(
  object,
  pool_size = c(2L, 2L, 2L),
  strides = NULL,
  padding = "valid",
  data_format = NULL,
  batch_size = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{pool_size}{list of 3 integers, factors by which to downscale (dim1,
dim2, dim3). (2, 2, 2) will halve the size of the 3D input in each
dimension.}

\item{strides}{list of 3 integers, or NULL. Strides values.}

\item{padding}{One of \code{"valid"} or \code{"same"} (case-insensitive).}

\item{data_format}{A string, one of \code{channels_last} (default) or
\code{channels_first}. The ordering of the dimensions in the inputs.
\code{channels_last} corresponds to inputs with shape \verb{(batch, spatial_dim1, spatial_dim2, spatial_dim3, channels)} while \code{channels_first} corresponds
to inputs with shape \verb{(batch, channels, spatial_dim1, spatial_dim2, spatial_dim3)}. It defaults to the \code{image_data_format} value found in your
Keras config file at \verb{~/.keras/keras.json}. If you never set it, then it
will be "channels_last".}

\item{batch_size}{Fixed batch size for layer}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Max pooling operation for 3D data (spatial or spatio-temporal).
}
\section{Input shape}{

\itemize{
\item If \code{data_format='channels_last'}: 5D tensor with shape: \verb{(batch_size, spatial_dim1, spatial_dim2, spatial_dim3, channels)}
\item If \code{data_format='channels_first'}: 5D tensor with shape: \verb{(batch_size, channels, spatial_dim1, spatial_dim2, spatial_dim3)}
}
}

\section{Output shape}{

\itemize{
\item If \code{data_format='channels_last'}: 5D tensor with shape: \verb{(batch_size, pooled_dim1, pooled_dim2, pooled_dim3, channels)}
\item If \code{data_format='channels_first'}: 5D tensor with shape: \verb{(batch_size, channels, pooled_dim1, pooled_dim2, pooled_dim3)}
}
}

\seealso{
Other pooling layers: 
\code{\link{layer_average_pooling_1d}()},
\code{\link{layer_average_pooling_2d}()},
\code{\link{layer_average_pooling_3d}()},
\code{\link{layer_global_average_pooling_1d}()},
\code{\link{layer_global_average_pooling_2d}()},
\code{\link{layer_global_average_pooling_3d}()},
\code{\link{layer_global_max_pooling_1d}()},
\code{\link{layer_global_max_pooling_2d}()},
\code{\link{layer_global_max_pooling_3d}()},
\code{\link{layer_max_pooling_1d}()},
\code{\link{layer_max_pooling_2d}()}
}
\concept{pooling layers}
