% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializers.R
\name{initializer_truncated_normal}
\alias{initializer_truncated_normal}
\title{Initializer that generates a truncated normal distribution.}
\usage{
initializer_truncated_normal(mean = 0, stddev = 0.05, seed = NULL)
}
\arguments{
\item{mean}{A numeric scalar. Mean of the random
values to generate.}

\item{stddev}{A numeric scalar. Standard deviation of
the random values to generate.}

\item{seed}{An integer or instance of
\code{random_seed_generator()}.
Used to make the behavior of the initializer
deterministic. Note that an initializer seeded with an integer
or \code{NULL} (unseeded) will produce the same random values
across multiple calls. To get different random values
across multiple calls, use as seed an instance
of \code{random_seed_generator()}.}
}
\value{
An \code{Initializer} instance that can be passed to layer or variable
constructors, or called directly with a \code{shape} to return a Tensor.
}
\description{
The values generated are similar to values from a
\code{RandomNormal} initializer, except that values more
than two standard deviations from the mean are
discarded and re-drawn.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Standalone usage:
initializer <- initializer_truncated_normal(mean = 0, stddev = 1)
values <- initializer(shape = c(2, 2))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Usage in a Keras layer:
initializer <- initializer_truncated_normal(mean = 0, stddev = 1)
layer <- layer_dense(units = 3, kernel_initializer = initializer)
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/initializers#truncatednormal-class}
}

Other random initializers: \cr
\code{\link{initializer_glorot_normal}()} \cr
\code{\link{initializer_glorot_uniform}()} \cr
\code{\link{initializer_he_normal}()} \cr
\code{\link{initializer_he_uniform}()} \cr
\code{\link{initializer_lecun_normal}()} \cr
\code{\link{initializer_lecun_uniform}()} \cr
\code{\link{initializer_orthogonal}()} \cr
\code{\link{initializer_random_normal}()} \cr
\code{\link{initializer_random_uniform}()} \cr
\code{\link{initializer_variance_scaling}()} \cr

Other initializers: \cr
\code{\link{initializer_constant}()} \cr
\code{\link{initializer_glorot_normal}()} \cr
\code{\link{initializer_glorot_uniform}()} \cr
\code{\link{initializer_he_normal}()} \cr
\code{\link{initializer_he_uniform}()} \cr
\code{\link{initializer_identity}()} \cr
\code{\link{initializer_lecun_normal}()} \cr
\code{\link{initializer_lecun_uniform}()} \cr
\code{\link{initializer_ones}()} \cr
\code{\link{initializer_orthogonal}()} \cr
\code{\link{initializer_random_normal}()} \cr
\code{\link{initializer_random_uniform}()} \cr
\code{\link{initializer_stft}()} \cr
\code{\link{initializer_variance_scaling}()} \cr
\code{\link{initializer_zeros}()} \cr
}
\concept{initializers}
\concept{random initializers}
