% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-attention.R
\name{layer_multi_head_attention}
\alias{layer_multi_head_attention}
\title{Multi Head Attention layer.}
\usage{
layer_multi_head_attention(
  inputs,
  num_heads,
  key_dim,
  value_dim = NULL,
  dropout = 0,
  use_bias = TRUE,
  output_shape = NULL,
  attention_axes = NULL,
  flash_attention = NULL,
  kernel_initializer = "glorot_uniform",
  bias_initializer = "zeros",
  kernel_regularizer = NULL,
  bias_regularizer = NULL,
  activity_regularizer = NULL,
  kernel_constraint = NULL,
  bias_constraint = NULL,
  seed = NULL,
  ...
)
}
\arguments{
\item{inputs}{see description}

\item{num_heads}{Number of attention heads.}

\item{key_dim}{Size of each attention head for query and key.}

\item{value_dim}{Size of each attention head for value.}

\item{dropout}{Dropout probability.}

\item{use_bias}{Boolean, whether the dense layers use bias vectors/matrices.}

\item{output_shape}{The expected shape of an output tensor, besides the batch
and sequence dims. If not specified, projects back to the query
feature dim (the query input's last dimension).}

\item{attention_axes}{axes over which the attention is applied. \code{NULL} means
attention over all axes, but batch, heads, and features.}

\item{flash_attention}{If \code{NULL}, the layer attempts to use flash
attention for faster and more memory-efficient attention
computations when possible. This behavior can be configured using
\code{config_enable_flash_attention()} or
\code{config_disable_flash_attention()}.}

\item{kernel_initializer}{Initializer for dense layer kernels.}

\item{bias_initializer}{Initializer for dense layer biases.}

\item{kernel_regularizer}{Regularizer for dense layer kernels.}

\item{bias_regularizer}{Regularizer for dense layer biases.}

\item{activity_regularizer}{Regularizer for dense layer activity.}

\item{kernel_constraint}{Constraint for dense layer kernels.}

\item{bias_constraint}{Constraint for dense layer kernels.}

\item{seed}{Optional integer to seed the dropout layer.}

\item{...}{For forward/backward compatability.}
}
\value{
The return value depends on the value provided for the first argument.
If  \code{object} is:
\itemize{
\item a \code{keras_model_sequential()}, then the layer is added to the sequential model
(which is modified in place). To enable piping, the sequential model is also
returned, invisibly.
\item a \code{keras_input()}, then the output tensor from calling \code{layer(input)} is returned.
\item \code{NULL} or missing, then a \code{Layer} instance is returned.
}
}
\description{
This is an implementation of multi-headed attention as described in the
paper "Attention is all you Need"
\href{https://arxiv.org/abs/1706.03762}{Vaswani et al., 2017}.
If \code{query}, \verb{key,} \code{value} are the same, then
this is self-attention. Each timestep in \code{query} attends to the
corresponding sequence in \code{key}, and returns a fixed-width vector.

This layer first projects \code{query}, \code{key} and \code{value}. These are
(effectively) a list of tensors of length \code{num_attention_heads}, where the
corresponding shapes are \verb{(batch_size, <query dimensions>, key_dim)},
\verb{(batch_size, <key/value dimensions>, key_dim)},
\verb{(batch_size, <key/value dimensions>, value_dim)}.

Then, the query and key tensors are dot-producted and scaled. These are
softmaxed to obtain attention probabilities. The value tensors are then
interpolated by these probabilities, then concatenated back to a single
tensor.

Finally, the result tensor with the last dimension as \code{value_dim} can take
a linear projection and return.
}
\section{Call Arguments}{
\itemize{
\item \code{query}: Query tensor of shape \verb{(B, T, dim)}, where \code{B} is the batch size,
\code{T} is the target sequence length, and dim is the feature dimension.
\item \code{value}: Value tensor of shape \verb{(B, S, dim)}, where \code{B} is the batch size,
\code{S} is the source sequence length, and dim is the feature dimension.
\item \code{key}: Optional key tensor of shape \verb{(B, S, dim)}. If not given, will
use \code{value} for both \code{key} and \code{value}, which is the most common
case.
\item \code{attention_mask}: a boolean mask of shape \verb{(B, T, S)}, that prevents
attention to certain positions. The boolean mask specifies which
query elements can attend to which key elements, 1 indicates
attention and 0 indicates no attention. Broadcasting can happen for
the missing batch dimensions and the head dimension.
\item \code{return_attention_scores}: A boolean to indicate whether the output should
be \verb{(attention_output, attention_scores)} if \code{TRUE}, or
\code{attention_output} if \code{FALSE}. Defaults to \code{FALSE}.
\item \code{training}: Python boolean indicating whether the layer should behave in
training mode (adding dropout) or in inference mode (no dropout).
Will go with either using the training mode of the parent
layer/model, or \code{FALSE} (inference) if there is no parent layer.
\item \code{use_causal_mask}: A boolean to indicate whether to apply a causal mask to
prevent tokens from attending to future tokens (e.g., used in a
decoder Transformer).
}
}

\section{Call return}{
\itemize{
\item attention_output: The result of the computation, of shape \verb{(B, T, E)},
where \code{T} is for target sequence shapes and \code{E} is the query input
last dimension if \code{output_shape} is \code{NULL}. Otherwise, the
multi-head outputs are projected to the shape specified by
\code{output_shape}.
\item attention_scores: (Optional) multi-head attention coefficients over
attention axes.
}
}

\section{Properties}{
A \code{MultiHeadAttention} \code{Layer} instance has the following additional read-only properties:
\itemize{
\item \code{attention_axes}
\item \code{dropout}
\item \code{key_dense}
\item \code{key_dim}
\item \code{num_heads}
\item \code{output_dense}
\item \code{output_shape}
\item \code{query_dense}
\item \code{use_bias}
\item \code{value_dense}
\item \code{value_dim}
}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/attention_layers/multi_head_attention#multiheadattention-class}
}

Other attention layers: \cr
\code{\link{layer_additive_attention}()} \cr
\code{\link{layer_attention}()} \cr
\code{\link{layer_group_query_attention}()} \cr

Other layers: \cr
\code{\link{Layer}()} \cr
\code{\link{layer_activation}()} \cr
\code{\link{layer_activation_elu}()} \cr
\code{\link{layer_activation_leaky_relu}()} \cr
\code{\link{layer_activation_parametric_relu}()} \cr
\code{\link{layer_activation_relu}()} \cr
\code{\link{layer_activation_softmax}()} \cr
\code{\link{layer_activity_regularization}()} \cr
\code{\link{layer_add}()} \cr
\code{\link{layer_additive_attention}()} \cr
\code{\link{layer_alpha_dropout}()} \cr
\code{\link{layer_attention}()} \cr
\code{\link{layer_aug_mix}()} \cr
\code{\link{layer_auto_contrast}()} \cr
\code{\link{layer_average}()} \cr
\code{\link{layer_average_pooling_1d}()} \cr
\code{\link{layer_average_pooling_2d}()} \cr
\code{\link{layer_average_pooling_3d}()} \cr
\code{\link{layer_batch_normalization}()} \cr
\code{\link{layer_bidirectional}()} \cr
\code{\link{layer_category_encoding}()} \cr
\code{\link{layer_center_crop}()} \cr
\code{\link{layer_concatenate}()} \cr
\code{\link{layer_conv_1d}()} \cr
\code{\link{layer_conv_1d_transpose}()} \cr
\code{\link{layer_conv_2d}()} \cr
\code{\link{layer_conv_2d_transpose}()} \cr
\code{\link{layer_conv_3d}()} \cr
\code{\link{layer_conv_3d_transpose}()} \cr
\code{\link{layer_conv_lstm_1d}()} \cr
\code{\link{layer_conv_lstm_2d}()} \cr
\code{\link{layer_conv_lstm_3d}()} \cr
\code{\link{layer_cropping_1d}()} \cr
\code{\link{layer_cropping_2d}()} \cr
\code{\link{layer_cropping_3d}()} \cr
\code{\link{layer_cut_mix}()} \cr
\code{\link{layer_dense}()} \cr
\code{\link{layer_depthwise_conv_1d}()} \cr
\code{\link{layer_depthwise_conv_2d}()} \cr
\code{\link{layer_discretization}()} \cr
\code{\link{layer_dot}()} \cr
\code{\link{layer_dropout}()} \cr
\code{\link{layer_einsum_dense}()} \cr
\code{\link{layer_embedding}()} \cr
\code{\link{layer_equalization}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{layer_flatten}()} \cr
\code{\link{layer_flax_module_wrapper}()} \cr
\code{\link{layer_gaussian_dropout}()} \cr
\code{\link{layer_gaussian_noise}()} \cr
\code{\link{layer_global_average_pooling_1d}()} \cr
\code{\link{layer_global_average_pooling_2d}()} \cr
\code{\link{layer_global_average_pooling_3d}()} \cr
\code{\link{layer_global_max_pooling_1d}()} \cr
\code{\link{layer_global_max_pooling_2d}()} \cr
\code{\link{layer_global_max_pooling_3d}()} \cr
\code{\link{layer_group_normalization}()} \cr
\code{\link{layer_group_query_attention}()} \cr
\code{\link{layer_gru}()} \cr
\code{\link{layer_hashed_crossing}()} \cr
\code{\link{layer_hashing}()} \cr
\code{\link{layer_identity}()} \cr
\code{\link{layer_integer_lookup}()} \cr
\code{\link{layer_jax_model_wrapper}()} \cr
\code{\link{layer_lambda}()} \cr
\code{\link{layer_layer_normalization}()} \cr
\code{\link{layer_lstm}()} \cr
\code{\link{layer_masking}()} \cr
\code{\link{layer_max_num_bounding_boxes}()} \cr
\code{\link{layer_max_pooling_1d}()} \cr
\code{\link{layer_max_pooling_2d}()} \cr
\code{\link{layer_max_pooling_3d}()} \cr
\code{\link{layer_maximum}()} \cr
\code{\link{layer_mel_spectrogram}()} \cr
\code{\link{layer_minimum}()} \cr
\code{\link{layer_mix_up}()} \cr
\code{\link{layer_multiply}()} \cr
\code{\link{layer_normalization}()} \cr
\code{\link{layer_permute}()} \cr
\code{\link{layer_rand_augment}()} \cr
\code{\link{layer_random_brightness}()} \cr
\code{\link{layer_random_color_degeneration}()} \cr
\code{\link{layer_random_color_jitter}()} \cr
\code{\link{layer_random_contrast}()} \cr
\code{\link{layer_random_crop}()} \cr
\code{\link{layer_random_erasing}()} \cr
\code{\link{layer_random_flip}()} \cr
\code{\link{layer_random_gaussian_blur}()} \cr
\code{\link{layer_random_grayscale}()} \cr
\code{\link{layer_random_hue}()} \cr
\code{\link{layer_random_invert}()} \cr
\code{\link{layer_random_perspective}()} \cr
\code{\link{layer_random_posterization}()} \cr
\code{\link{layer_random_rotation}()} \cr
\code{\link{layer_random_saturation}()} \cr
\code{\link{layer_random_sharpness}()} \cr
\code{\link{layer_random_shear}()} \cr
\code{\link{layer_random_translation}()} \cr
\code{\link{layer_random_zoom}()} \cr
\code{\link{layer_repeat_vector}()} \cr
\code{\link{layer_rescaling}()} \cr
\code{\link{layer_reshape}()} \cr
\code{\link{layer_resizing}()} \cr
\code{\link{layer_rms_normalization}()} \cr
\code{\link{layer_rnn}()} \cr
\code{\link{layer_separable_conv_1d}()} \cr
\code{\link{layer_separable_conv_2d}()} \cr
\code{\link{layer_simple_rnn}()} \cr
\code{\link{layer_solarization}()} \cr
\code{\link{layer_spatial_dropout_1d}()} \cr
\code{\link{layer_spatial_dropout_2d}()} \cr
\code{\link{layer_spatial_dropout_3d}()} \cr
\code{\link{layer_spectral_normalization}()} \cr
\code{\link{layer_stft_spectrogram}()} \cr
\code{\link{layer_string_lookup}()} \cr
\code{\link{layer_subtract}()} \cr
\code{\link{layer_text_vectorization}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{layer_time_distributed}()} \cr
\code{\link{layer_torch_module_wrapper}()} \cr
\code{\link{layer_unit_normalization}()} \cr
\code{\link{layer_upsampling_1d}()} \cr
\code{\link{layer_upsampling_2d}()} \cr
\code{\link{layer_upsampling_3d}()} \cr
\code{\link{layer_zero_padding_1d}()} \cr
\code{\link{layer_zero_padding_2d}()} \cr
\code{\link{layer_zero_padding_3d}()} \cr
\code{\link{rnn_cell_gru}()} \cr
\code{\link{rnn_cell_lstm}()} \cr
\code{\link{rnn_cell_simple}()} \cr
\code{\link{rnn_cells_stack}()} \cr
}
\concept{attention layers}
\concept{layers}
