% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys-get.R
\name{keys-get}
\alias{keys-get}
\alias{keys}
\alias{raw_keys}
\alias{has_keys}
\title{Get keys}
\usage{
keys(.tbl)

raw_keys(.tbl)

has_keys(.tbl)
}
\arguments{
\item{.tbl}{Reference data frame.}
}
\value{
\code{keys()} always returns a \link[tibble:lst]{tibble} of keys. In case of
no keys it returns a tibble with number of rows as in \code{.tbl} and zero
columns. \code{raw_keys()} is just a wrapper for \code{attr(.tbl, "keys")}.
To know whether \code{.tbl} has keys use \code{has_keys()}.
}
\description{
Functions for getting information about keys.
}
\examples{
keys(mtcars)

raw_keys(mtcars)

has_keys(mtcars)

df <- key_by(mtcars, vs, am)
keys(df)

has_keys(df)

}
\seealso{
\link[=keys-set]{Set keys}, \link[=keys-manipulate]{Manipulate keys}
}
