% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{mreach.closeness}
\alias{mreach.closeness}
\title{Compute the M-reach Closeness Centrality Score in a Netwrok}
\usage{
mreach.closeness(adj.matrix, node, M = Inf, binary = FALSE, cmode = "all")
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.}

\item{node}{Integer indicating the column index of the chosen player
in the adjacenncy matrix. If not specified, scores for all nodes will be reported.}

\item{M}{Number indicating the maximum geodistance between two nodes,
above witch the two nodes are considered disconnected.
M hence defines the reachable set. The default is \code{Inf}.}

\item{binary}{If \code{TRUE}, the adjacency matrix is binarized.
If \code{FALSE}, the edge values are considered.}

\item{cmode}{String indicating the type of centrality being evaluated.
\code{"outdegree"}, \code{"indegree"}, and \code{"total"} refer to
indegree, outdegree, and (total) degree respectively. \code{"all"} reports
all the above measures and is the default.}
}
\value{
A vector indicating the outdegree, indegree, or total-degree
cohesion score of the chosen player; or a data frame containing all
the above information. Note that we normalize the outdegree and indegree scores
to [0,1]. This means that the total-degree score is between [0,2].
}
\description{
\code{mreach.closeness} refines the \code{\link{mreach.degree}} centrality by
using the (inverse) geodistance as weights.
The edge values should be properly interpreted as distances.
}
\details{
\code{mreach.closeness} refines the \code{\link{mreach.degree}} centrality
by using the (inverse) geodistance as weights, just as \code{\link[sna]{closeness}}
centrality refines \code{\link[sna]{degree}} centrality.
The delimiting definition of neighborhoods given by M induces several flexible
properties of the M-reach closeness centrality. It captures
the degree centrality when M is properly set (e.g. M=1 in a binarized network).
It captures the Gil-Schmidt power index (Gil and Schmidt, 1996)
and the cohesion centrality (Borgatti, 2006) when M is sufficiently large
(unconstrained). The normalization factor takes care of non-binary
edge values interpreted as distances. Also note that the geodistance matrix does
not necessarily to be symmetric, and thus the measure is directed.
see An and Liu (2015) for more details.
}
\examples{
# Create a 5x5 weighted and directed adjacency matrix, where edge values
# represent the strength of tie
W <- matrix(
  c(0,1,3,0,0,
    0,0,0,4,0,
    1,1,0,2,0,
    0,0,0,0,3,
    0,2,0,0,0),
    nrow=5, ncol=5, byrow = TRUE)

# Transform the edge value to distance interpretaion
A <- W
A[W!=0] <- 1/W[W!=0]

# List all types of 2-reach closeness scores for every node
mreach.closeness(A,M=2,cmode="all")
}
\author{
Weihua An \email{weihuaan@indiana.edu}; Yu-Hsin Liu \email{yuhsliu@indiana.edu}
}
\references{
An, Weihua and Yu-Hsin Liu (2015). "keyplayer: An R Package for Locating Key Players in Social Networks."
\emph{Working Paper}, Indiana Univeristy.\cr

Borgatti, Stephen P. (2006). "Identifying Sets of Key Players in a Network."
\emph{Computational, Mathematical and Organizational Theory}, 12(1):21-34.\cr

Gil, J and Schmidt, S (1996). "The Origin of the Mexican Network of Power."
Proceedings of the International Social Network Conference, Charleston, SC, 22-25.\cr
}
\seealso{
\code{\link[sna]{geodist}};
\code{\link{kpcent}};
\code{\link{kpset}}
}

