% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LookupCZ.R
\name{LookupCZ}
\alias{LookupCZ}
\title{LookupCZ}
\usage{
LookupCZ(data, res = "course", rc = FALSE)
}
\arguments{
\item{data}{The co-ordinates for the location you are trying to predict the climate zone of (format is three column dataframe, first column site IDs, second column longitude values, third column latitude values).}

\item{res}{Specify the resolution as a string - 'course' for lower resolution (default, 0.5 degrees), 'fine' for higher resolution (100s).}

\item{rc}{Specify whether to generate the rounded coordinate columns in the input dataframe, default is FALSE.}
}
\value{
The climate zone for the co-ordinates provided.
}
\description{
This function will return the climate zone for the co-ordinates provided.
}
\examples{
data <- data.frame(Site = c("GC","UFS","NEG"),
  Longitude = c(-15.42,10.98,34.78),
  Latitude = c(27.82,47.42,30.86))
data <- data.frame(data,
  rndCoord.lon = RoundCoordinates(data$Longitude),
  rndCoord.lat = RoundCoordinates(data$Latitude))
data <- data.frame(data,ClimateZ=LookupCZ(data))
}
