% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_kgraph.R
\name{build_kgraph}
\alias{build_kgraph}
\title{Build a knowledge graph}
\usage{
build_kgraph(
  selected_concepts,
  df_weights,
  df_dict = NULL,
  rm_single_groups = TRUE,
  df_sup_nodes = NULL,
  display_val_digits = 3,
  display_val_str = "\\nCosine similarity: ",
  str_other = "Other",
  highlight_mult = TRUE,
  multiline_labs = TRUE,
  autoscale = TRUE,
  spring_weights = TRUE,
  n_max_edges = 1000,
  ...
)
}
\arguments{
\item{selected_concepts}{Concepts of interest}

\item{df_weights}{Data frame with columns concept1, concept2, and weight;
typically the df_projs slot of the object returned by
function fit_embeds_to_pairs}

\item{df_dict}{Dictionary data frame, with columns id (matched to concepts
in df_weights), desc (for labels), color, and optionally
group.}

\item{rm_single_groups}{Should groups with only one element be removed}

\item{df_sup_nodes}{Data frame of supplementary nodes (work in progress)}

\item{display_val_digits}{Number of weight digits to be displayed in labels}

\item{display_val_str}{String to prefix to the displayed value}

\item{str_other}{String to use for missing groups}

\item{highlight_mult}{Highlight nodes connected to multiple nodes of
interest.}

\item{multiline_labs}{Use multiline labels (shown when hovered on)}

\item{autoscale}{Perform scaling with sgraph::scale_graph}

\item{spring_weights}{Use spring weights (reverts edges weights)}

\item{n_max_edges}{Threshold on number of edges}

\item{...}{Passed to scale_kgraph}
}
\value{
Knowledge graph, list of slots df_nodes and df_links
}
\description{
Build a knowledge graph
}
