% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_way_anova.R
\name{two_way_anova}
\alias{two_way_anova}
\title{Two-way ANOVA}
\usage{
two_way_anova(
  data,
  dv_name,
  iv_1_name,
  iv_2_name,
  iv_1_values = NULL,
  iv_2_values = NULL,
  robust = TRUE,
  iterations = 2000,
  plot = FALSE,
  ci = NULL,
  se = NULL,
  pi = NULL,
  ci_range = 0.95,
  pi_range = 0.95,
  line_size = 1,
  dot_size = 3,
  error_bar_width = 0.13,
  position_dodge = 0.13,
  legend_position = "right",
  output = NULL
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{dv_name}{name of the dependent variable}

\item{iv_1_name}{name of the first independent variable}

\item{iv_2_name}{name of the second independent variable}

\item{iv_1_values}{restrict all analyses to observations having
these values for the first independent variable}

\item{iv_2_values}{restrict all analyses to observations having
these values for the second independent variable}

\item{robust}{if \code{TRUE}, conduct a robust ANOAVA in addition.}

\item{iterations}{number of bootstrap samples for robust ANOVA.
The default is set at 2000, but consider increasing the number
of samples to 5000, 10000, or an even larger number, if slower
handling time is not an issue.}

\item{plot}{if \code{TRUE}, print a plot and enable returning an output.}

\item{ci}{if \code{TRUE}, error bars will be a confidence interval}

\item{se}{if \code{TRUE}, error bars will be +/-1 standard error}

\item{pi}{if \code{TRUE}, error bars will be a prediction interval}

\item{ci_range}{width of the confidence interval
(default = 0.95 for 95 percent confidence interval)}

\item{pi_range}{width of the prediction interval
(default = 0.95 for 95 percent prediction interval)}

\item{line_size}{thickness of the lines connecting group means,
(default = 1)}

\item{dot_size}{size of the dots indicating group means (default = 3)}

\item{error_bar_width}{graphically, width of the segments
at the end of error bars (default = 0.13)}

\item{position_dodge}{by how much should the group means and error bars
be horizontally offset from each other so as not to overlap?
(default = 0.13)}

\item{legend_position}{position of the legend:
"none", "top", "right", "bottom", "left", "none" (default = "right")}

\item{output}{output type can be one of the following: \code{"anova_table"},
\code{"group_stats"}, \code{"plot"}, \code{"levene_test_result"},
\code{"robust_anova_results"}, \code{"robust_anova_post_hoc_results"},
\code{"robust_anova_post_hoc_contrast"}}
}
\value{
by default, the output will be \code{"anova_table"}
}
\description{
Two-way ANOVA
}
\examples{
two_way_anova(data = mtcars, dv_name = "mpg", iv_1_name = "vs",
iv_2_name = "am", iterations = 100)
}
