% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediation_analysis.R
\name{mediation_analysis}
\alias{mediation_analysis}
\title{Mediation analysis}
\usage{
mediation_analysis(
  data = NULL,
  iv_name = NULL,
  mediator_name = NULL,
  dv_name = NULL,
  covariates_names = NULL,
  robust_se = TRUE,
  iterations = 1000,
  sigfigs = 3,
  output_type = "summary_dt",
  silent = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable}

\item{mediator_name}{name of the mediator variable}

\item{dv_name}{name of the dependent variable}

\item{covariates_names}{names of covariates to control for}

\item{robust_se}{if \code{TRUE}, heteroskedasticity-consistent
standard errors will be used in quasi-Bayesian simulations. By default,
it will be set as \code{FALSE} if nonparametric bootstrap is used and
as \code{TRUE} if quasi-Bayesian approximation is used.}

\item{iterations}{number of bootstrap samples. The default is set at 1000,
but consider increasing the number of samples to 5000, 10000, or an
even larger number, if slower handling time is not an issue.}

\item{sigfigs}{number of significant digits to round to}

\item{output_type}{if \code{output_type = "summary_dt"},
return the summary data.table; if \code{output_type = "mediate_output"},
return the output from the \code{mediate} function in the
'mediate' package; if \code{output_type = "indirect_effect_p"},
return the p value associated with the indirect effect estimated
in the mediation model (default = "summary_dt")}

\item{silent}{if \code{silent = FALSE}, mediation analysis summary,
estimation method, sample size, and number of simulations will be
printed; if \code{silent = TRUE}, nothing will be printed.
(default = FALSE)}
}
\value{
if \code{output_type = "summary_dt"}, which is the default,
the output will be a data.table showing a summary of mediation
analysis results; if \code{output_type = "mediate_output"},
the output will be the output from the \code{mediate} function
in the 'mediate' package; if \code{output_type = "indirect_effect_p"},
the output will be the p-value associated with the indirect effect
estimated in the mediation model (a numeric vector of length one).
}
\description{
Conducts a mediation analysis to estimate an independent variable's
indirect effect on dependent variable through a mediator variable.
The current version of the package only supports a simple mediation
model consisting of one independent variable, one mediator variable,
and one dependent variable.
Uses the source code from 'mediation' package v4.5.0,
Tingley et al. (2019)
\url{https://cran.r-project.org/package=mediation}
}
\examples{
\donttest{
mediation_analysis(
  data = mtcars, iv_name = "cyl",
  mediator_name = "disp", dv_name = "mpg", iterations = 100
)
mediation_analysis(
  data = iris, iv_name = "Sepal.Length",
  mediator_name = "Sepal.Width", dv_name = "Petal.Length",
  iterations = 100
)
}
}
