% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_stats_by_group.R
\name{desc_stats_by_group}
\alias{desc_stats_by_group}
\title{Descriptive statistics by group}
\usage{
desc_stats_by_group(
  data = NULL,
  var_for_stats = NULL,
  grouping_vars = NULL,
  stats = "all",
  sigfigs = NULL,
  cols_to_round = NULL
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{var_for_stats}{name of the variable for which descriptive
statistics will be calculated}

\item{grouping_vars}{name(s) of grouping variables}

\item{stats}{statistics to calculate. If \code{stats = "basic"},
group size, mean, standard deviation, median, minimum, and maximum will
be calculated. If \code{stats = "all"}, in addition to the
aforementioned statistics, standard error, 95\% confidence and
prediction intervals, skewness, and kurtosis will also be calculated.
The \code{stats} argument can also be a character vector with types of
statistics to calculate. For example, entering
\code{stats = c("mean", "median")} will calculate mean and median.
By default, \code{stats = "all"}}

\item{sigfigs}{number of significant digits to round to}

\item{cols_to_round}{names of columns whose values will be rounded}
}
\value{
the output will be a data.table showing descriptive statistics
of the variable for each of the groups formed by the grouping variables.
}
\description{
Returns descriptive statistics by group
}
\examples{
desc_stats_by_group(data = mtcars, var_for_stats = "mpg",
grouping_vars = c("vs", "am"))
desc_stats_by_group(data = mtcars, var_for_stats = "mpg",
grouping_vars = c("vs", "am"), sigfigs = 3)
desc_stats_by_group(data = mtcars, var_for_stats = "mpg",
grouping_vars = c("vs", "am"), stats = "basic", sigfigs = 2)
desc_stats_by_group(data = mtcars, var_for_stats = "mpg",
grouping_vars = c("vs", "am"), stats = "basic", sigfigs = 2,
cols_to_round = "all")
desc_stats_by_group(data = mtcars, var_for_stats = "mpg",
grouping_vars = c("vs", "am"), stats = c("mean", "median"), sigfigs = 2,
cols_to_round = "all")
}
