% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustboot.R
\name{clustboot}
\alias{clustboot}
\title{Bootstrap replications for clustering alorithm}
\usage{
clustboot(distdata, nclust = 2, algorithm, nboot = 25, diss = TRUE)
}
\arguments{
\item{distdata}{A matrix of distance objects (n x n) or a diss class.}

\item{nclust}{The number of clusters}

\item{algorithm}{Any clustering algorithm function with the end result being only membership.}

\item{nboot}{The number of bootstrap replicates}

\item{diss}{A logical if the distdata is a dist or matrix object.}
}
\value{
Function returns a bootstrap cluster matrix (n x number of bootstrap replicates).
}
\description{
This function do bootstrap replications for a cluster algorithm.
}
\details{
This is a function to obtain bootstrap evaluation for a cluster. The cluster matrix
can be further analyzed. In the algorithm function, the input arguments are only a distance/ matrix
and a number of cluster.The output is only the membership.
}
\examples{
num <- as.matrix(iris[,1:4])
mrwdist <- distNumeric(num, num, method = "mrw")
parkboot <- function(x, nclust) {
res <- fastkmed(x, nclust, iterate = 50)
return(res$cluster)
}
irisboot <- clustboot(mrwdist, nclust=3, parkboot, nboot=7)
head(irisboot)


}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
