% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\docType{data}
\name{opts_knit}
\alias{opts_knit}
\title{Options for the knitr package}
\format{An object of class \code{list} of length 6.}
\usage{
opts_knit
}
\description{
Options including whether to use a progress bar when knitting a document, and
the base directory of images, etc.
}
\details{
Besides the standard usage (\code{opts_knit$set()}), we can also set package
options prior to loading \code{knitr} or calling \code{knit()} using
\code{\link{options}()} in base R. A global option \code{knitr.package.foo}
in \code{options()} will be set as an option \code{foo} in \code{opts_knit},
i.e. global options in base R with the prefix \code{knitr.package.}
correspond to options in \code{opts_knit}. This can be useful to set package
options in \file{~/.Rprofile} without loading \pkg{knitr}.

See \code{str(knitr::opts_knit$get())} for a list of default package options.
}
\examples{
opts_knit$get("verbose")
opts_knit$set(verbose = TRUE)  # change it
if (interactive()) {
    # for unnamed chunks, use 'fig' as the figure prefix
    opts_knit$set(unnamed.chunk.label = "fig")
    knit("001-minimal.Rmd")  # from https://github.com/yihui/knitr-examples
}
}
\references{
Usage: \url{https://yihui.name/knitr/objects/}

  A list of available options:
  \url{https://yihui.name/knitr/options/#package_options}
}
\keyword{datasets}
