% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstudio_addins.R
\encoding{UTF-8}
\name{insert_data_chunk_dialog}
\alias{insert_data_chunk_dialog}
\title{Invoke Rstudio addin to insert a data chunk in active source document}
\usage{
insert_data_chunk_dialog(title = "Data chunk inserter", chunk = NULL)
}
\arguments{
\item{title}{Text to place in title bar of gadget.}

\item{chunk}{Text content of the data chunk. If not given (as is typically the case), the
\code{\link{create_data_chunk_dialog}} will be used to generate chunk contents.}
}
\value{
Returns \code{TRUE} if a chunk was inserted, \code{FALSE} otherwise.
}
\description{
As different elements of the data chunk are specified, other options will be modified
as is likely to be useful. For example, if a binary file is uploaded, then the \code{format}
will be set to \code{binary}, the \code{encoding} will be set to \code{base64} and the
\code{Encode data?} option will be checked. If these options are not appropriate, then they can
be altered afterwards.
}
\details{
When the \code{Create chunk} button is clicked, the contents of the data chunk will be inserted
at the current cursor location of the active source document in the Rstudio editor.
}
\examples{
\dontrun{
insert_data_chunk_dialog()
}

}
\seealso{
Other Chunk tools: 
\code{\link{create_chunk}()},
\code{\link{create_data_chunk_dialog}()},
\code{\link{list_rmd_chunks}()},
\code{\link{remove_chunks_dialog}()}
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}
}
\concept{Chunk tools}
