% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kntn_parse.R
\name{kntn_parse}
\alias{kntn_parse}
\alias{kntn_parse_field}
\alias{kntn_parse_record}
\alias{kntn_parse_records}
\title{Parse 'kintone' API Response}
\usage{
kntn_parse_record(record, as = c("data.frame", "list"))

kntn_parse_records(records)

kntn_parse_field(x)
}
\arguments{
\item{record}{List object converted from a single kintone record.}

\item{as}{Desired type of output: \code{data.frame} or \code{list}.}

\item{records}{List objects converted from multiple kintone records.}
}
\description{
Convert various kinds of fields to the correspondent R classes.
}
\examples{
library(jsonlite)

rcd_file <- system.file("extdata/record.json", package = "kntnr")
rcd <- fromJSON(rcd_file, simplifyVector = FALSE)$record
kntnr:::kntn_parse_record(rcd)

rcds_file <- system.file("extdata/records.json", package = "kntnr")
rcds <- jsonlite::fromJSON(rcds_file, simplifyVector = FALSE)$records
kntnr:::kntn_parse_records(rcds)

}
\seealso{
\url{https://developer.kintone.io/hc/en-us/articles/212494818/}
}
\keyword{internal}

