\name{farr.jenkins.paterson}
\alias{farr.jenkins.paterson}
\title{Readability: Farr-Jenkins-Paterson Index}
\usage{
  farr.jenkins.paterson(txt.file, hyphen = NULL,
    parameters = c(const = -31.517, asl = 1.015, monsy = 1.599),
    ...)
}
\arguments{
  \item{txt.file}{Either an object of class
  \code{\link[koRpus]{kRp.tagged-class}}, a character
  vector which must be be a valid path to a file containing
  the text to be analyzed, or a list of text features. If
  the latter, calculation is done by
  \code{\link[koRpus:readability.num]{readability.num}}.}

  \item{hyphen}{An object of class kRp.hyphen. If
  \code{NULL}, the text will be hyphenated automatically.}

  \item{parameters}{A numeric vector with named magic
  numbers, defining the relevant parameters for the index,
  or \code{"PSK"}.}

  \item{...}{Further valid options for the main function,
  see \code{\link[koRpus:readability]{readability}} for
  details.}
}
\value{
  An object of class
  \code{\link[koRpus]{kRp.readability-class}}.
}
\description{
  This is just a convenient wrapper function for
  \code{\link[koRpus:readability]{readability}}.
}
\details{
  Calculates the Farr-Jenkins-Paterson index, a simplified
  version of Flesch Reading Ease. In contrast to
  \code{\link[koRpus:readability]{readability}}, which by
  default calculates all possible indices, this function
  will only calculate the index value.

  If \code{parameters="PSK"}, the revised parameters by
  Powers-Sumner-Kearl (1958) are used.
}
\examples{
\dontrun{
farr.jenkins.paterson(tagged.text)
}
}
\references{
  Farr, J.N., Jenkins, J.J. & Paterson, D.G. (1951).
  Simplification of Flesch Reading Ease formula.
  \emph{Journal of Applied Psychology}, 35(5), 333--337.

  Powers, R.D, Sumner, W.A, & Kearl, B.E. (1958). A
  recalculation of four adult readability formulas,
  \emph{Journal of Educational Psychology}, 49(2), 99--105.
}
\seealso{
  \code{\link[koRpus:flesch]{flesch}}
}
\keyword{readability}

