% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_val_labs.R
\name{use_val_labs}
\alias{use_val_labs}
\alias{uvl}
\title{Swap Variable Value Labels for Variable Values}
\usage{
use_val_labs(data, vars = NULL)

uvl(data, vars = NULL)
}
\arguments{
\item{data}{a data.frame.}

\item{vars}{the names of the columns (variables) for which labels-on
versions of the variable will replace the original variable in the returned
data.frame.}
}
\value{
A data.frame, with (all or the select) variable value labels "turned
on" (i.e., substituted for original variable values), and any affected
variables coerced to character if they were not already.
}
\description{
Replace the actual values of data.frame variables with the corresponding
value labels (previous assigned using \code{add_val_labs} or a related function).
}
\details{
Note: \code{uvl} is a compact alias for \code{use_val_labs}: they do the same thing,
and the former is easier to type.

Warning: \code{use_val_labs} will replace existing variable values with value
labels and cannot be undone. If you wish to preserve variable values, be sure
to assign the result of \code{use_val_labs} to a new object (vs. overwriting the
data.frame you supply to the data argument), OR use \code{add_lab_cols} to add
variables containing value labels to the supplied data set without replacing
the original variables, OR use \code{val_abs_vec} to replace a single column's
values with its value labels and return the result as a stand-alone character
vector. For other ways to leverage value labels for common data management or
inspection tasks, while preserving raw data values in returned object, see
\code{flab} ("filter using labels"), \code{slab} ("subset using labels"), \code{tabl}
(tabulate frequencies using labels), \code{somel}, \code{headl}, and \code{taill}.

\code{use_val_labs} works with \code{add_val_labs}, \code{add_val1}, \code{add_quant_labs},
\code{add_q1}, \code{add_m1_lab}, \code{add1m1}, \code{get_val_labs}, \code{drop_val_labs}, and
\code{drop_val1} to facilitate creation, modification, accessing, use, and
destruction of variable-specific value labels.

\code{use_val_labs} takes a variable value-labeled data.frame and substitutes each
(labeled) variable's labels for its values, returning a data.frame whose
dimensions, names, and members are the same as the inputted data.frame. This
may be useful if one wishes to inspect the data.frame (using, e.g., head(),
tail(), View()) or labeled value frequencies (e.g., table()) using the
(potentially) more intuitively meaningful value labels (e.g., gender=1 values
displayed as "Male" instead of 1).
}
\examples{
# Example #1 - mtcars example, one variable at a time
# one variable at a time, mtcars
df <- mtcars
# now, add value labels
df <- add_val_labs(
  data = df,
  vars = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

df <- add_val_labs(
  data = df,
  vars = "carb",
  vals = c(1, 2, 3, 4, 6, 8),
  labs = c(
    "1-carb", "2-carbs",
    "3-carbs", "4-carbs",
    "6-carbs", "8-carbs"
  )
)

# var arg can be unquoted if using add_val1()
# note that this is not add_val_labs(); add_val1() has "var" (not "vars) arg
df <- add_val1(
  data = df,
  var = cyl, # note, "var," not "vars" arg
  vals = c(4, 6, 8),
  labs = c(
    "four-cyl",
    "six-cyl",
    "eight-cyl"
  )
)

df <- add_val_labs(
  data = df,
  vars = "gear",
  vals = c(3, 4),
  labs = c(
    "3-speed",
    "4-speed"
  )
)

# Oops, we forgot 5-speeds; let's finish the job.
df <- add_val_labs(
  data = df,
  vars = "gear",
  vals = 5,
  labs = "5-speed"
)

head(use_val_labs(df), 3) # they're there

# Example #2 - (Fake) Likert Data
# add val labs to multiple variables at once
# make a "Likert"-type fake data set to demo
# note, by default, add_val_labs() "vars" arg will do partial matching
# in this case, we catch all vars with "x" in their name
set.seed(272)
dflik <- make_likert_data(scale = 1:7)
vals2label <- 1:7
labs2use <- c(
  "VSD",
  "SD",
  "D",
  "N",
  "A",
  "SA",
  "VSA"
)

dflik <- add_val_labs(
  data = dflik, vars = c("x", "y3"), # note the vars args
  vals = vals2label,
  labs = labs2use,
  partial = TRUE
)

# note, all "x" vars get the labs, as does "y3"
# see vars = args above
lik1 <- use_val_labs(dflik)
head(lik1)
# keep a copy
dflik_conv <- use_val_labs(dflik)
head(dflik_conv, 3)
}
