% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{thetaLS}
\alias{thetaLS}
\title{Least squares (LS) estimator}
\usage{
thetaLS(x, k = NULL, x0 = NULL)
}
\arguments{
\item{x}{a numeric vector.}

\item{k}{the number of observations in the upper tail to which the Pareto
distribution is fitted.}

\item{x0}{the threshold (scale parameter) above which the Pareto distribution
is fitted.}
}
\value{
The estimated shape parameter.
}
\description{
Estimate the shape parameter of a Pareto distribution using a least squares
(LS) approach.
}
\details{
The arguments \code{k} and \code{x0} of course correspond with each other.
If \code{k} is supplied, the threshold \code{x0} is estimated with the \eqn{n
- k} largest value in \code{x}, where \eqn{n} is the number of observations.
On the other hand, if the threshold \code{x0} is supplied, \code{k} is given
by the number of observations in \code{x} larger than \code{x0}.  Therefore,
either \code{k} or \code{x0} needs to be supplied.  If both are supplied,
only \code{k} is used (mainly for back compatibility).
}
\note{
The argument \code{x0} for the threshold (scale parameter) of the
Pareto distribution was introduced in version 0.2.
}
\examples{
data(eusilc)
# equivalized disposable income is equal for each household
# member, therefore only one household member is taken
eusilc <- eusilc[!duplicated(eusilc$db030),]

# estimate threshold
ts <- paretoScale(eusilc$eqIncome, w = eusilc$db090)

# using number of observations in tail
thetaLS(eusilc$eqIncome, k = ts$k)

# using threshold
thetaLS(eusilc$eqIncome, x0 = ts$x0)
}
\author{
Andreas Alfons and Josef Holzer
}
\references{
Brazauskas, V. and Serfling, R. (2000) Robust estimation of tail
parameters for two-parameter Pareto and exponential models via generalized
quantile statistics. \emph{Extremes}, \bold{3}(3), 231--249.

Brazauskas, V. and Serfling, R. (2000) Robust and efficient estimation of the
tail index of a single-parameter Pareto distribution. \emph{North American
Actuarial Journal}, \bold{4}(4), 12--27.
}
\seealso{
\code{\link{paretoTail}}, \code{\link{fitPareto}}
}
\keyword{manip}

