% Generated by roxygen2 (4.0.1): do not edit by hand
\name{lakeFetch}
\alias{lakeFetch}
\title{Function to calculate fetch along an input bearing}
\usage{
lakeFetch(inLakeMorpho, bearing, addLine = T)
}
\arguments{
\item{inLakeMorpho}{An object of \code{\link{lakeMorphoClass}}.  Output of the
\code{\link{lakeSurroundTopo}} function would be appropriate as input}

\item{bearing}{Character that indicates the bearing of the desired fetch}

\item{addLine}{Boolean to determine if the selected max length line should be
added to the inLakeMorpho object.  Defaults to True.  Note that the
line is returned in the same projection as the input data.}
}
\value{
Returns a numeric value indicating the length of the longest
        line in the lake along the input bearing. Units are the same as the
        input data.
}
\description{
The function calculates the maximum in lake distance of a line along an input
bearing.
}
\examples{
data(lakes)
lakeFetch(inputLM,45)
}
\references{
Florida LAKEWATCH (2001). A Beginner's guide to water management
            - Lake Morphometry (2nd ed.). Gainesville: Florida LAKEWATCH,
            Department of Fisheries and Aquatic Sciences.
            \href{http://edis.ifas.ufl.edu/pdffiles/FA/FA08100.pdf}{Link}
}

