% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TT2tri.R
\name{TT2tri}
\alias{TT2tri}
\title{Soil texture class to texture fractions conversion}
\usage{
TT2tri(
  TT.class,
  se.fit = TRUE,
  TT.im = NULL,
  soil.var = "TEXMHT",
  levs = c("S", "LS", "SL", "SCL", "SiL", "SiCL", "CL", "L", "Si", "SC", "SiC", "C",
    "HC")
)
}
\arguments{
\item{TT.class}{based on the soiltexture package}

\item{se.fit}{derive errors}

\item{TT.im}{soil texture triangle image}

\item{soil.var}{column name in the TT.im file}

\item{levs}{texture class legends (USDA system)}
}
\value{
Data frame with estimated sand, silt and clay values
}
\description{
Soil texture class to texture fractions conversion
}
\examples{
library(soiltexture)
## convert textures by hand to sand, silt and clay:
TEXMHT <- c("CL","C","SiL","SiL","missing")
x <- TT2tri(TEXMHT)
x
}
