% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lsm.R
\name{get_lsm}
\alias{get_lsm}
\alias{get_lsm.RasterLayer}
\alias{get_lsm.RasterStack}
\alias{get_lsm.RasterBrick}
\alias{get_lsm.stars}
\alias{get_lsm.list}
\title{get_lsm}
\usage{
get_lsm(landscape, what, level, metric, name, type, directions,
  count_boundary, consider_boundary, edge_depth, classes_max,
  neighbourhood, ordered, base, verbose)

\method{get_lsm}{RasterLayer}(landscape, what = NULL, level = "patch",
  metric = NULL, name = NULL, type = NULL, directions = 8,
  count_boundary = FALSE, consider_boundary = FALSE, edge_depth = 1,
  classes_max = NULL, neighbourhood = 4, ordered = TRUE,
  base = "log2", verbose = TRUE)

\method{get_lsm}{RasterStack}(landscape, what = NULL, level = "patch",
  metric = NULL, name = NULL, type = NULL, directions = 8,
  count_boundary = FALSE, consider_boundary = FALSE, edge_depth = 1,
  classes_max = NULL, neighbourhood = 4, ordered = TRUE,
  base = "log2", verbose = TRUE)

\method{get_lsm}{RasterBrick}(landscape, what = NULL, level = "patch",
  metric = NULL, name = NULL, type = NULL, directions = 8,
  count_boundary = FALSE, consider_boundary = FALSE, edge_depth = 1,
  classes_max = NULL, neighbourhood = 4, ordered = TRUE,
  base = "log2", verbose = TRUE)

\method{get_lsm}{stars}(landscape, what = NULL, level = "patch",
  metric = NULL, name = NULL, type = NULL, directions = 8,
  count_boundary = FALSE, consider_boundary = FALSE, edge_depth = 1,
  classes_max = NULL, neighbourhood = 4, ordered = TRUE,
  base = "log2", verbose = TRUE)

\method{get_lsm}{list}(landscape, what = NULL, level = "patch",
  metric = NULL, name = NULL, type = NULL, directions = 8,
  count_boundary = FALSE, consider_boundary = FALSE, edge_depth = 1,
  classes_max = NULL, neighbourhood = 4, ordered = TRUE,
  base = "log2", verbose = TRUE)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{what}{Selected level of metrics: either "patch", "class" or "landscape".
It is also possible to specify functions as a vector of strings, e.g. \code{what = c("lsm_c_ca", "lsm_l_ta")}.}

\item{level}{Level of metrics to calculate (e.g. 'landscape').}

\item{metric}{Abbreviation of metrics to calculate (e.g. 'area').}

\item{name}{Full name of metrics to calculate (e.g. 'core area').}

\item{type}{Metric types to calculate according to FRAGSTATS grouping (e.g. 'aggregation metric').}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{count_boundary}{Include landscape boundary in edge length}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}

\item{classes_max}{Potential maximum number of present classes}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours:
4 (rook's case) or 8 (queen's case). The default is 4.}

\item{ordered}{The type of pairs considered. Either ordered (TRUE) or unordered (FALSE).
The default is TRUE.}

\item{base}{The unit in which entropy is measured. The default is "log2",
which compute entropy in "bits". "log" and "log10" can be also used.}

\item{verbose}{Print warning messages}
}
\value{
list
}
\description{
Get landscape metric values
}
\details{
The functions returns a nested list with \code{RasterLayer}s. The first level
contains each input layer (only one element if \code{RasterLayer} was provided).
The second level contains a \code{RasterLayer} for each selected metric
(see \code{list_lsm} for details) where each cell has the landscape metric
value of the patch it belongs to. Only patch level metrics are allowed.
}
\examples{
\dontrun{
get_lsm(landscape, what = "lsm_p_area")
get_lsm(landscape_stack, what = c("lsm_p_area", "lsm_p_perim"))
}

}
\seealso{
\code{\link{list_lsm}} \cr
\code{\link{show_lsm}}
}
