% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_pladj.R
\name{lsm_c_pladj}
\alias{lsm_c_pladj}
\title{PLADJ (class level)}
\usage{
lsm_c_pladj(landscape)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}
}
\value{
tibble
}
\description{
Percentage of Like Adjacencies (Aggregation metric)
}
\details{
\deqn{PLADJ = (\frac{g_{ij}} {\sum \limits_{k = 1}^{m} g_{ik}}) * 100}
where \eqn{g_{ii}} is the number of adjacencies between cells of class i
and \eqn{g_{ik}} is the number of adjacencies between cells of class i and k.

PLADJ is an 'Aggregation metric'. It calculates the frequency how often patches of
different classes i (focal class) and k are next to each other, and following is a
measure of class aggregation. The adjacencies are counted using the double-count method.

\subsection{Units}{Percent}
\subsection{Ranges}{0 <= PLADJ <= 100}
\subsection{Behaviour}{Equals PLADJ = 0 if class i is maximal disaggregated,
i.e. every cell is a different patch. Equals PLADJ = 100 when the only one patch
is present.}
}
\examples{
lsm_c_pladj(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html.
}
