% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_dcad.R
\name{lsm_c_dcad}
\alias{lsm_c_dcad}
\title{DCAD (class level)}
\usage{
lsm_c_dcad(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Disjunct core area density (core area metric)
}
\details{
\deqn{DCAD = (\frac{\sum \limits_{j = 1}^{n} n_{ij}^{core}} {A}) * 10000 * 100}
where \eqn{n_{ij}^{core}} is the number of disjunct core areas and \eqn{A}
is the total landscape area in square meters.

DCAD is a 'Core area metric'. It equals the number of disjunct core areas per
100 ha relative to the total area. A disjunct core area is a 'patch within
the patch' containing only core cells. A cell is defined as core area if the cell has no
neighbour with a different value than itself (rook's case). The metric is relative and
therefore comparable among landscapes with different total areas.

\subsection{Units}{Number per 100 hectares}
\subsection{Range}{DCAD >= 0}
\subsection{Behaviour}{Equals DCAD = 0 when DCORE = 0, i.e. no patch of class i contains
a disjunct core area. Increases, without limit, as disjunct core areas become more
present, i.e. patches becoming larger and less complex.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_dcad(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_c_ndca}},
\code{\link{lsm_l_ta}}, \cr
\code{\link{lsm_l_dcad}}
}
