% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{formatNum}
\alias{formatNum}
\title{Nicely Format Numerical Values}
\usage{
formatNum(
  x,
  decimals = 2,
  signif = NULL,
  type = Sys.getenv("LARES_NUMFORMAT"),
  pre = "",
  pos = "",
  sign = FALSE,
  abbr = FALSE,
  ...
)
}
\arguments{
\item{x}{Numerical Vector}

\item{decimals}{Integer. Amount of decimals to display.}

\item{signif}{Integer. Rounds the values in its first argument to
the specified number of significant digits.}

\item{type}{Integer. \code{1} for International standards. \code{2}
for American Standards. Use \code{Sys.setenv("LARES_NUMFORMAT" = 2)} 
to set this parameter globally.}

\item{pre, pos}{Character. Add string before or after number.}

\item{sign}{Boolean. Add \code{+} sign to positive values.}

\item{abbr}{Boolean. Abbreviate using num_abbr()? You can use
the `decimals` parameter to set abbr's \code{n}(-1) parameter.}

\item{...}{Additional lazy eval parameters.}
}
\value{
Character. String vector with reformatted continuous numbers
}
\description{
This function lets the user format numerical values nicely
}
\examples{
formatNum(1.23456, decimals = 3)
formatNum(1.23456, type = 1)
formatNum(1.23456, pre = "$", pos = "/person")
formatNum(123456, abbr = TRUE)
formatNum(1234567890, abbr = TRUE, signif = 2)
formatNum(1234567890, decimals = 0, abbr = TRUE)
formatNum(c(-3:3), sign = TRUE)
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{numericalonly}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{removenacols}()},
\code{\link{removenarows}()},
\code{\link{replaceall}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{year_week}()}
}
\concept{Data Wrangling}
