% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{winsorize}
\alias{winsorize}
\title{Outliers: Winsorize}
\usage{
winsorize(x, thresh = c(0.05, 0.95), na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector. Distribution to be winsorized.}

\item{thresh}{Numeric vector. Lower and upper quantiles thresholds.
Set values within [0,1].}

\item{na.rm}{Boolean. Should \code{NA} be omitted to calculate the quantiles? 
Note that \code{NA} in \code{x} are preserved and left unchanged anyway.}
}
\value{
Numeric vector transformed.
}
\description{
Winsorizing a vector means that a predefined quantum of the smallest 
and/or the largest values are replaced by less extreme values. 
Thereby the substitute values are the most extreme retained values.
}
\seealso{
Other Outliers: 
\code{\link{outlier_turkey}()},
\code{\link{outlier_zscore_plot}()},
\code{\link{outlier_zscore}()}
}
\concept{Outliers}
