% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling.R
\name{removenacols}
\alias{removenacols}
\alias{removenarows}
\alias{numericalonly}
\title{Remove/Drop Columns in which ALL or SOME values are NAs}
\usage{
removenacols(df, all = TRUE, ignore = NULL)

removenarows(df, all = TRUE)

numericalonly(df, dropnacols = TRUE, logs = FALSE, natransform = NA)
}
\arguments{
\item{df}{Data.frame}

\item{all}{Boolean. Remove rows which contains ONLY NA values.
If set to FALSE, rows which contains at least one NA will be removed}

\item{ignore}{Character vector. Column names to ignore validation.}

\item{dropnacols}{Boolean. Drop columns with only NA values?}

\item{logs}{Boolean. Calculate log(x)+1 for numerical columns?}

\item{natransform}{String. "mean" or 0 to impute NA values. If
set to NA no calculation will run.}
}
\value{
data.frame with removed columns.

data.frame with removed rows.

data.frame with all numerical columns selected.
}
\description{
This function lets the user remove all columns that have some or
all values as NAs

This function lets the user remove all rows that have some or
all values as NAs
}
\examples{
data(dft) # Titanic dataset
str(dft)
numericalonly(dft) \%>\% head()
numericalonly(dft, natransform = "mean") \%>\% head()
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{file_name}()},
\code{\link{formatHTML}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{num_abbr}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{quants}()},
\code{\link{replaceall}()},
\code{\link{replacefactor}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{zerovar}()}

Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{file_name}()},
\code{\link{formatHTML}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{num_abbr}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{quants}()},
\code{\link{replaceall}()},
\code{\link{replacefactor}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{zerovar}()}

Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{file_name}()},
\code{\link{formatHTML}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{num_abbr}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{quants}()},
\code{\link{replaceall}()},
\code{\link{replacefactor}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{zerovar}()}
}
\concept{Data Wrangling}
