% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf.R
\name{viewtex}
\alias{viewtex}
\title{Render and View TEX Files}
\usage{
viewtex(x, delete = TRUE, latency = 1, png = FALSE, ...)
}
\arguments{
\item{x}{vector of file names}

\item{delete}{whether temporary pdf (_doc.pdf) should persist}

\item{latency}{how many seconds to wait before deleting temporary PDF,}

\item{png}{view as png instead of pdf}

\item{...}{passed to \code{\link{tex2pdf}}}
}
\description{
Renders and TEX files as PDF and opens them for viewing.
}
\examples{
file <- file.path(tempdir(),'test.tex')
writeLines(as.ltable(head(Theoph)), file)
\dontrun{
viewtex(file)
viewtex(file, png = TRUE, gs_cmd = 'mgs')
}
}
\seealso{
\code{\link{tex2pdf}}

\code{\link{tex2png}}

\code{\link{as.pdf.character}}
}
