% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{confusionMatrix}
\alias{confusionMatrix}
\title{Compute the posterior confusion matrix}
\usage{
confusionMatrix(object, strategy = which.max, scale = TRUE)
}
\arguments{
\item{object}{The object.}

\item{strategy}{The \link{trajectoryAssignments} strategy to compute the PCM under.
If \code{strategy = NULL}, weighted random assignment is assumed (analogous to a repeated [\link{which.weight}] strategy evaluation).}

\item{scale}{Whether to express the confusion in probabilities (\code{scale = TRUE}), or in the number of trajectories.}
}
\description{
Compute a \verb{nClusters x nClusters} posterior confusion matrix (PCM). The entry (i,j) represents the probability of a trajectory belonging to class i is assigned to class j under a given assignment strategy.
}
\examples{
data(latrendData)
model = latrend(method=lcMethodLcmmGMM(Y ~ CLUSTER * Time + (1 | Id), id = "Id", time = "Time"),
  data=latrendData)
confusionMatrix(model)
}
