% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-transform.R
\name{transformFitted}
\alias{transformFitted}
\alias{transformFitted,NULL,lcModel-method}
\alias{transformFitted,matrix,lcModel-method}
\alias{transformFitted,list,lcModel-method}
\alias{transformFitted,data.frame,lcModel-method}
\title{Helper function for custom lcModel classes implementing fitted.lcModel()}
\usage{
transformFitted(pred, model, clusters)

\S4method{transformFitted}{`NULL`,lcModel}(pred, model, clusters = NULL)

\S4method{transformFitted}{matrix,lcModel}(pred, model, clusters = NULL)

\S4method{transformFitted}{list,lcModel}(pred, model, clusters = NULL)

\S4method{transformFitted}{data.frame,lcModel}(pred, model, clusters = NULL)
}
\arguments{
\item{pred}{The cluster-specific predictions for each observation}

\item{model}{The \code{lcModel} by which the prediction was made.}

\item{clusters}{The trajectory cluster assignment per observation. Optional.}
}
\value{
If the \code{clusters} argument was specified, a \code{vector} of fitted values conditional on the given cluster assignment. Else, a \code{matrix} with the fitted values per cluster per column.
}
\description{
A helper function for implementing the \code{\link[=fitted.lcModel]{fitted.lcModel()}} method as part of your own \code{lcModel} class, ensuring the correct output type and format (see the Value section).
Note that this function has no use outside of implementing \code{fitted.lcModel}.

The function makes it easier to implement \code{fitted.lcModel} based on existing implementations that may output their results in different data formats. Furthermore, the function checks whether the input data is valid.

The prediction ordering depends on the ordering of the data observations that was used for fitting the \code{lcModel}.

By default, \code{transformFitted()} accepts one of the following inputs:
\describe{
\item{\code{data.frame}}{A \code{data.frame} in long format providing a cluster-specific prediction for each observation per row, with column names \code{"Fit"} and \code{"Cluster"}. This \code{data.frame} therefore has \code{nobs(object) * nClusters(object)} rows.}
\item{\code{matrix}}{An N-by-K \code{matrix} where each row provides the cluster-specific predictions for the respective observation. Here, \code{N = nrow(model.data(object))} and \code{K = nClusters(object)}.}
\item{\code{list}}{A \code{list} of cluster-specific prediction \code{vector}s. Each prediction vector should be of length \code{nrow(model.data(object))}. The overall (named) list of cluster-specific prediction vectors is of length \code{nClusters(object)}.}
}

Users can implement support for other prediction formats by defining the \code{transformFitted} method with other signatures.
}
\section{Example implementation}{

A typical implementation of \code{\link[=fitted.lcModel]{fitted.lcModel()}} for your own \code{lcModel} class would have the following format:
\preformatted{
fitted.lcModelExample <- function(object,
 clusters = trajectoryAssignments(object)) {
  # computations of the fitted values per cluster here
  predictionMatrix <- CODE_HERE
  transformFitted(pred = predictionMatrix, model = object, clusters = clusters)
}
}

For a complete and runnable example, see the custom models vignette accessible via \code{vignette("custom", package = "latrend")}.
}

