% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/trajectories.R, R/model.R
\name{trajectories}
\alias{trajectories}
\alias{trajectories,data.frame-method}
\alias{trajectories,matrix-method}
\alias{trajectories,call-method}
\alias{trajectories,lcModel-method}
\title{Extract the trajectories}
\usage{
trajectories(
  object,
  id = idVariable(object),
  time = timeVariable(object),
  response = responseVariable(object),
  ...
)

\S4method{trajectories}{data.frame}(
  object,
  id = idVariable(object),
  time = timeVariable(object),
  response = responseVariable(object),
  ...
)

\S4method{trajectories}{matrix}(
  object,
  id = idVariable(object),
  time = timeVariable(object),
  response = responseVariable(object),
  ...
)

\S4method{trajectories}{call}(object, ..., envir)

\S4method{trajectories}{lcModel}(
  object,
  id = idVariable(object),
  time = timeVariable(object),
  response = responseVariable(object),
  ...
)
}
\arguments{
\item{object}{The data or model or extract the trajectories from.}

\item{id}{The identifier variable name, see \link{idVariable}.}

\item{time}{The time variable name, see \link{timeVariable}.}

\item{response}{The response variable name, see \link{responseVariable}.}

\item{...}{Not used.}

\item{envir}{The \code{environment} used to evaluate the data object in (e.g., in case \code{object} is of type \code{call}).}
}
\value{
A \code{data.frame} with columns matching the \code{id}, \code{time}, and \code{response} name arguments.
}
\description{
Transform or extract the trajectories from the given object to a standardized format.

The standardized data format is for method estimation by \link{latrend}, and for plotting functions.
}
\details{
The generic function removes unused factor levels in the Id column, and any trajectories which are only comprised of NAs in the response.
}
\seealso{
\link{plotTrajectories} \link{latrend}
}
