\name{kill}
\alias{kill}
\alias{kill<-}
\alias{rmvar}
\alias{rmvar<-}
\title{Remove variables from (model) object.}
\usage{
kill(x, ...) <- value
}
\arguments{
  \item{x}{Model object}

  \item{value}{Vector of variables or formula specifying
  which nodes to remove}

  \item{\dots}{additional arguments to lower level
  functions}
}
\description{
Generic method for removing elements of object
}
\examples{
m <- lvm()
addvar(m) <- ~y1+y2+x
covariance(m) <- y1~y2
regression(m) <- c(y1,y2) ~ x
### Cancel the covariance between the residuals of y1 and y2
cancel(m) <- y1~y2
### Remove y2 from the model
rmvar(m) <- ~y2
}
\author{
Klaus K. Holst
}
\seealso{
\code{cancel}
}
\keyword{models}
\keyword{regression}

