% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.calibrateType1.R
\name{autoplot_calibrateType1}
\alias{autoplot_calibrateType1}
\alias{autoplot.calibrateType1}
\title{Graphical Display of the Bias or Type 1 Error}
\usage{
\method{autoplot}{calibrateType1}(object, type = "bias", plot = TRUE,
  color.threshold = "red", type.bias = "absolute", alpha = 0.05,
  nrow.legend = NULL, name2label = NULL, color = NULL,
  keep.method = NULL)
}
\arguments{
\item{object}{output of \code{\link{calibrateType1}}.}

\item{type}{[character] if type equals \code{"bias"} the bias will be displayed.
Otherwise if it equals \code{"type1error"} the type 1 error will be displayed.}

\item{plot}{[logical] should the plot be displayed?}

\item{color.threshold}{[character] the color for the line representing the expected value(s).}

\item{type.bias}{[character] if type.bias equals \code{"absolute"} the absolute bias will be used.
Otherwise if it equals \code{"relative"} the relative bias will be used.
Only relevant when type equals \code{"bias"}.}

\item{alpha}{[numeric, 0-1] the significance threshold to consider.
Only relevant when type equals \code{"type1error"}.}

\item{nrow.legend}{[integer, >0] the number of rows for the legend.
Only relevant when type equals \code{"type1error"}.}

\item{name2label}{[named character vector] the label for the legend.
The vector should contain the method names (see details).
Only relevant when type equals \code{"type1error"}.}

\item{color}{[character vector] a vector of colours to be used to color the lines.
Only relevant when type equals \code{"type1error"}.}

\item{keep.method}{[character vector] the methods names for which the type 1 error should be displayed.
Only relevant when type equals \code{"type1error"}.}
}
\value{
An list containing:
\itemize{
\item plot: a ggplot object.
\item data: the dataset used to generate the ggplot object.
}
}
\description{
Graphical display of the bias or type 1 error
for the output of \code{\link{calibrateType1}}.
}
\details{
Method names:
\itemize{
\item \code{p.Ztest}
\item \code{p.Satt}
\item \code{p.KR}
\item \code{p.robustZtest}
\item \code{p.robustSatt}
\item \code{p.robustKR}
}
}
