% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle.R
\name{lawn_circle}
\alias{lawn_circle}
\title{circle}
\usage{
lawn_circle(center, radius, steps = FALSE, units = "kilometers",
  lint = FALSE)
}
\arguments{
\item{center}{the center \code{\link{data-Point}}}

\item{radius}{(integer) radius of the circle}

\item{steps}{(integer) number of steps}

\item{units}{(character) (default kilometers) ) miles, kilometers,
degrees, or radians}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
a

a \code{\link{data-Polygon}}
}
\description{
Takes a \code{\link{data-Point}} and calculates the circle polygon given
a radius in degrees, radians, miles, or kilometers; and steps for precision
}
\examples{
pt <- '{
  "type": "Feature",
  "properties": {
    "marker-color": "#0f0"
  },
  "geometry": {
    "type": "Point",
    "coordinates": [-75.343, 39.984]
  }
}'

lawn_circle(pt, radius = 5, steps = 10)
}
\seealso{
Other assertions: \code{\link{lawn_tesselate}}
}

