% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evir.R
\name{evir}
\alias{evir}
\alias{alogLik.gev}
\alias{alogLik.gpd}
\alias{alogLik.potd}
\title{Loglikelihood adjustment for evir fits}
\usage{
\method{alogLik}{gev}(x, cluster = NULL, use_vcov = TRUE, ...)

\method{alogLik}{gpd}(x, cluster = NULL, use_vcov = TRUE, ...)

\method{alogLik}{potd}(x, cluster = NULL, use_vcov = TRUE, ...)
}
\arguments{
\item{x}{A fitted model object with certain associated S3 methods.
See \strong{Details}.}

\item{cluster}{A vector or factor indicating from which cluster the
  respective log-likelihood contributions from \code{loglik} originate.
  The length of \code{cluster} must be consistent with the \code{estfun}
  method to be used in the estimation of the 'meat' \code{V} of the sandwich
  estimator of the covariance matrix of the parameters to be passed to
  \code{\link[chandwich]{adjust_loglik}}.  In most cases, \code{cluster}
  must have length equal to the number of observations in data.  The
  exception is the GP (only) model (\code{binom = FALSE}), where the
  \code{cluster} may either contain a value for each observation in the raw
  data, or for each threshold exceedance in the data.

  If \code{cluster} is not supplied (is \code{NULL}) then it is
  assumed that each observation forms its own cluster.
  See \strong{Details} for further details.}

\item{use_vcov}{A logical scalar.  Should we use the \code{vcov} S3 method
for \code{x} (if this exists) to estimate the Hessian of the independence
loglikelihood to be passed as the argument \code{H} to
\code{\link[chandwich]{adjust_loglik}}?
Otherwise, \code{H} is estimated inside
\code{\link[chandwich]{adjust_loglik}} using
\code{\link[stats:optim]{optimHess}}.}

\item{...}{Further arguments to be passed to the functions in the
sandwich package \code{\link[sandwich]{meat}} (if \code{cluster = NULL}),
or \code{\link[sandwich:vcovCL]{meatCL}} (if \code{cluster} is not
\code{NULL}).}
}
\value{
An object inheriting from class \code{"chandwich"}.  See
  \code{\link[chandwich]{adjust_loglik}}.
  \code{class(x)} is a vector of length 5. The first 3 components are
  \code{c("lax", "chandwich", "evir")}.
  The remaining 2 components depend on the model that was fitted.
  If \code{\link[evir]{gev}} was used then these components are
  \code{c("gev", "stat")}.
  If \code{\link[evir]{gpd}} was used then these components are
  \code{c("gpd", "stat")}.
  If \code{\link{pot_refit}} was used then these components are
  \code{c("potd", "stat")}.
}
\description{
S3 \code{alogLik} method to perform loglikelihood adjustment for fitted
extreme value model objects returned from the functions
\code{\link[evir]{gev}}, \code{\link[evir]{gpd}} and \code{\link[evir]{pot}}
in the evir package.
If \code{x} was returned from \code{\link[evir]{pot}} then the model will
need to be re-fitted using \code{\link{pot_refit}}.
}
\details{
See \code{\link{alogLik}} for details.

If \code{\link[evir]{pot}} was used then \code{x} does not contain the
raw data that \code{alogLik} needs.  The model will need to be
re-fitted using \code{\link{pot_refit}} and the user will be prompted to
do this by an error message produced by \code{\link{alogLik}}.
}
\examples{
# We need the evir package
got_evir <- requireNamespace("evir", quietly = TRUE)
if (got_evir) {
  library(evir)
  # An example from the evir::gev documentation
  data(bmw)
  out <- gev(bmw, "month")
  adj_out <- alogLik(out)
  summary(adj_out)

  # An example from the evir::gpd documentation
  data(danish)
  out <- gpd(danish, 10)
  adj_out <- alogLik(out)
  summary(adj_out)

  # An example from the evir::pot documentation
  # We use lax::pot_refit() to return the input data
  out <- pot_refit(danish, 10)
  adj_out <- alogLik(out)
  summary(adj_out)
}
}
\references{
Chandler, R. E. and Bate, S. (2007). Inference for clustered
  data using the independence loglikelihood. \emph{Biometrika},
  \strong{94}(1), 167-183. \doi{10.1093/biomet/asm015}

Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{The Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \doi{10.1214/09-AOAS292}

Zeileis (2006) Object-Oriented Computation and Sandwich
  Estimators.  \emph{Journal of Statistical Software}, \strong{16}, 1-16.
  \doi{10.18637/jss.v016.i09}
}
\seealso{
\code{\link{alogLik}}: loglikelihood adjustment for model fits.
}
