% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lazy.text.R
\name{lazy.text}
\alias{lazy.text}
\title{Paragraphs in LaTeX}
\usage{
lazy.text(..., title = NULL, align = "left", italic = FALSE,
  bold = FALSE, underline = FALSE, sep = "", translate = TRUE, font,
  family, size)
}
\arguments{
\item{...}{Text and other objects to be included in the paragraph}

\item{title}{A title for the paragraph}

\item{align}{alignment of the paragraph.  Options are \code{"left",
"center", "right"}.}

\item{italic}{Logical.  Indicates if the text should be italicized}

\item{bold}{Logical.  Indicates if the text shoudl be bolded}

\item{underline}{Logical.  Indicates if the text should be underlined}

\item{sep}{Character.  Denotes the separation string for the items in
\code{...} when they are pasted together}

\item{translate}{Toggles if inputs in \code{x} should be passed through
\code{latexTranslate}.  This should be set to \code{FALSE} if writing
custom code.}

\item{font}{HTML font for the paragraph. Defaults to the HTML option
(see \code{\link{setHtmlOptions}}).}

\item{family}{HTML font family for the paragraph. Defaults to the HTML
option (see \code{\link{setHtmlOptions}}).}

\item{size}{Text size of the paragraph.   Defaults to the HTML option
  (see \code{\link{setHtmlOptions}}). May be an integer or a LaTeX size
  descriptor. See "Details" for options}
}
\description{
Paragraphs in LaTeX
}
\details{
Write paragraphs in LaTeX code
}
\examples{
\dontrun{
lazy.write(
  lazy.file.start(),
  lazy.text("Typically we want our paragraphs to be left
    justified.  This is often what we expect to see when reading."),
  lazy.text("However, we may also have occasions where we would
    like to center our text.  It's one of many ways we can make the
    words stand out on the page", align="center"),
  lazy.text("A more traditional way to make the text stand out might be
    to use bold text or italics, such as these", bold=TRUE, italic=TRUE),
  lazy.file.end(),
  OutFile="Example 1.tex")

unlink("Example 1.tex")
}
}
\author{
Benjamin Nutter
}

