% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictClass.R
\name{predictClass}
\alias{predictClass}
\title{Posterior classification and class-membership probabilities}
\usage{
predictClass(model, newdata, subject = NULL)
}
\arguments{
\item{model}{an object inheriting from class \code{hlme}, \code{lcmm}, 
\code{Jointlcmm} or \code{multlcmm} representing a general latent class
mixed model.}

\item{newdata}{data frame containing the data from which predictions are to be computed.
The data frame should include at least all the covariates listed in model$Xnames2,
the outcome(s) and the grouping structure. Names should match exactly.}

\item{subject}{character specifying the name of the grouping structure.
If NULL (the default), the same as in the model will be used.}
}
\value{
a matrix with 2+ng columns: the grouping structure, the predicted class and the
ng posterior class-membership probabilities.
}
\description{
This function provides the posterior classification and posterior individual 
class-membership probabilities for external data.
}
\examples{
\dontrun{
library(NormPsy)
paquid$normMMSE <- normMMSE(paquid$MMSE)
paquid$age65 <- (paquid$age - 65)/10
m2b <- hlme(normMMSE ~ age65+I(age65^2)+CEP, random =~ age65+I(age65^2), subject = 'ID',
data = paquid, ng = 2, mixture =~ age65+I(age65^2), B = c(0, 60, 40, 0, -4, 0, -10, 10,
212.869397, -216.421323,456.229910, 55.713775, -145.715516, 59.351000, 10.072221))
predictClass(m2b, newdata=paquid[1:6,])
}
}
\author{
Sasha Cuau, Viviane Philipps, Cecile Proust-Lima
}
