% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_model_s3.R
\docType{class}
\name{ldmppr_mark_model}
\alias{ldmppr_mark_model}
\alias{print.ldmppr_mark_model}
\alias{predict.ldmppr_mark_model}
\alias{save_mark_model}
\alias{save_mark_model.ldmppr_mark_model}
\alias{load_mark_model}
\title{Mark model object}
\usage{
ldmppr_mark_model(
  engine,
  fit_engine = NULL,
  xgb_raw = NULL,
  recipe = NULL,
  outcome = "size",
  feature_names = NULL,
  info = list()
)

\method{print}{ldmppr_mark_model}(x, ...)

\method{predict}{ldmppr_mark_model}(object, new_data, ...)

save_mark_model(object, path, ...)

\method{save_mark_model}{ldmppr_mark_model}(object, path, ...)

load_mark_model(path)
}
\arguments{
\item{engine}{Character scalar. One of `"xgboost"` or `"ranger"`.}

\item{fit_engine}{Fitted engine object (e.g. `xgb.Booster` or a ranger fit).}

\item{xgb_raw}{Raw xgboost payload (e.g. UBJ) used for rehydration.}

\item{recipe}{A prepped recipes object used for preprocessing new data.}

\item{outcome}{Outcome column name (default `"size"`).}

\item{feature_names}{Optional vector of predictor names required at prediction time.}

\item{info}{Optional list of metadata.}

\item{x}{a `ldmppr_mark_model` object.}

\item{...}{passed to methods.}

\item{object}{a `ldmppr_mark_model` object.}

\item{new_data}{a data frame of predictors (and possibly outcome columns).}

\item{path}{path to an `.rds` created by [save_mark_model()] (or legacy objects).}
}
\value{
* `print()` prints a brief summary.
* `predict()` returns numeric predictions for new data.

an object of class `"ldmppr_mark_model"`.
}
\description{
`ldmppr_mark_model` objects store a fitted mark model and preprocessing
information used to predict marks at new locations and times.
}
\details{
These objects are typically returned by [train_mark_model()] and can be
saved/loaded with [save_mark_model()] and [load_mark_model()].


The model may be backed by different engines (currently `"xgboost"` and
`"ranger"`). For xgboost, the object can store a serialized booster payload
to make saving/loading robust across R sessions.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(ldmppr_mark_model)}: Print a brief summary of the mark model.

\item \code{predict(ldmppr_mark_model)}: Predict marks for new data.

\item \code{save_mark_model(ldmppr_mark_model)}: Save method for `ldmppr_mark_model`.

}}
\section{Functions}{
\itemize{
\item \code{ldmppr_mark_model()}: Create a mark model container.

\item \code{save_mark_model()}: Save a mark model to disk.

\item \code{load_mark_model()}: Load a saved mark model from disk.

}}
