% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast.R
\name{gl_to_gp}
\alias{gl_to_gp}
\title{Normalize genotype likelihoods to posterior probabilities.}
\usage{
gl_to_gp(gl)
}
\arguments{
\item{gl}{A three dimensional array of genotype \emph{log}-likelihoods.
Element \code{gl[i, j, k]} is the genotype log-likelihood of dosage
\code{k} for individual \code{j} at SNP \code{i}.}
}
\value{
A three-dimensional array, of the same dimensions as \code{gl},
containing the posterior probabilities of each dosage.
}
\description{
This will take genotype log-likelihoods and normalize them to
sum to one. This corresponds to using a naive discrete uniform prior
over the genotypes, which is typically OK if we are not adaptively
estimating likelihood elements using this prior.
}
\examples{
data("glike")
class(glike)
dim(glike)
gl_to_gp(glike)

}
\author{
David Gerard
}
